/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpeechBubble;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpriteResources;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerShop;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.runecraftory.common.network.C2SShopButton;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import io.github.flemmli97.tenshilib.client.gui.widget.TexturedButton;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public class NPCShopGui
extends AbstractContainerScreen<ContainerShop> {
    protected static final ResourceLocation BACKGROUND = RuneCraftory.modRes("textures/gui/container/shop.png");
    private final Inventory inventory;
    private Slot lastClickSlotShop;
    private boolean isLeftClickDown;
    private boolean isRightClickDown;
    private int clickDelay;
    private int rightDelay = 50;
    private int leftDelay = 50;
    private AbstractWidget next;
    private AbstractWidget prev;
    private SpeechBubble speech;

    public NPCShopGui(ContainerShop abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.inventory = inventory;
    }

    protected void init() {
        this.imageWidth = 245;
        this.imageHeight = 217;
        super.init();
        this.prev = new TexturedButton(this.leftPos + 14, this.topPos + 8, 12, 12, (Component)Component.literal((String)"<"), b -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SShopButton(false))).withSprite(SpriteResources.PAGE_BUTTON);
        this.addRenderableWidget((GuiEventListener)this.prev);
        this.next = new TexturedButton(this.leftPos + 121, this.topPos + 8, 12, 12, (Component)Component.literal((String)">"), b -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SShopButton(true))).withSprite(SpriteResources.PAGE_BUTTON);
        this.addRenderableWidget((GuiEventListener)this.next);
        this.updateButtons();
        this.speech = new SpeechBubble(this.minecraft, this.leftPos + 148, this.topPos + 10, 100, 40);
        this.addRenderableOnly(this.speech);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, (Component)Component.literal((String)("" + ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.minecraft.player)).getMoney())), (float)(this.leftPos + 237), (float)(this.topPos + 197), 0, false);
        if (((ContainerShop)this.menu).getCurrentCost() > 0) {
            GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, (Component)Component.literal((String)("" + ((ContainerShop)this.menu).getCurrentCost())), (float)(this.leftPos + 237), (float)(this.topPos + 175), 0, false);
        }
        graphics.enableScissor(this.leftPos + 148, this.topPos, this.leftPos + this.width - 148, this.topPos + 126);
        RenderUtils.renderScaledEntityGui((GuiGraphics)graphics, (float)(this.leftPos + 156), (float)(this.topPos + 55), (float)80.0f, (float)100.0f, (float)50.0f, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)((ContainerShop)this.menu).getShopOwner());
        graphics.disableScissor();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.lastClickSlotShop != this.hoveredSlot) {
            this.lastClickSlotShop = null;
            this.isLeftClickDown = false;
            this.isRightClickDown = false;
        }
        if (this.lastClickSlotShop != null) {
            --this.clickDelay;
            if (this.isLeftClickDown) {
                this.rightDelay = 50;
                if (--this.leftDelay <= 0 && this.clickDelay <= 0) {
                    ClickType click = NPCShopGui.hasShiftDown() ? ClickType.QUICK_MOVE : ClickType.PICKUP;
                    this.slotClicked(this.lastClickSlotShop, this.lastClickSlotShop.index, 0, click);
                    this.clickDelay = 4;
                }
            } else if (this.isRightClickDown) {
                this.leftDelay = 50;
                if (--this.rightDelay <= 0 && this.clickDelay <= 0) {
                    ClickType click = NPCShopGui.hasShiftDown() ? ClickType.QUICK_MOVE : ClickType.PICKUP;
                    this.slotClicked(this.lastClickSlotShop, this.lastClickSlotShop.index, 1, click);
                    this.clickDelay = 4;
                }
            } else {
                this.leftDelay = 50;
                this.rightDelay = 50;
            }
        }
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.slotClicked(slot, slotId, mouseButton, type);
        this.lastClickSlotShop = slot != null && slot.container != this.inventory ? slot : null;
        this.isLeftClickDown = mouseButton == 0;
        this.isRightClickDown = mouseButton == 1;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isLeftClickDown = false;
        this.isRightClickDown = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        GuiGraphicsExtension.drawCenteredString(graphics, this.font, this.title, 74.0f, 10.0f, 0, false);
    }

    public void removed() {
        super.removed();
        LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SNPCInteraction(((ContainerShop)this.menu).getShopOwner().getId(), C2SNPCInteraction.Action.CLOSE));
    }

    public void drawBubble(Component txt) {
        this.speech.showBubble(txt, 200);
    }

    public void updateButtons() {
        if (this.next != null) {
            this.next.visible = ((ContainerShop)this.menu).hasNext();
        }
        if (this.prev != null) {
            this.prev.visible = ((ContainerShop)this.menu).hasPrev();
        }
    }
}

