/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.client.ClientCalendarHolder;
import io.github.flemmli97.runecraftory.client.gui.GuiUtils;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpriteResources;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class OverlayGui {
    private static final ResourceLocation HEALTH_BAR_BACKGROUND = RuneCraftory.modRes("hud/overlay/health_bar_background");
    private static final ResourceLocation HEALTH_BAR = RuneCraftory.modRes("hud/overlay/health_bar");
    private static final ResourceLocation RUNEPOINTS_BAR_BACKGROUND = RuneCraftory.modRes("hud/overlay/runepoints_bar_background");
    private static final ResourceLocation RUNEPOINTS_BAR = RuneCraftory.modRes("hud/overlay/runepoints_bar");
    private static final Map<Season, ResourceLocation> DATE = Arrays.stream(Season.values()).collect(Collectors.toUnmodifiableMap(e -> e, e -> RuneCraftory.modRes("hud/overlay/date_" + e.name().toLowerCase())));
    private final Minecraft mc;

    public OverlayGui(Minecraft mc) {
        this.mc = mc;
    }

    public void renderBar(GuiGraphics graphics) {
        int yPos;
        int xPos;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = this.mc.getWindow().getGuiScaledWidth();
        int guiHeight = this.mc.getWindow().getGuiScaledHeight();
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.mc.player);
        if (ClientConfig.renderHealthRpBar != ClientConfig.HealthRPRenderType.NONE) {
            int barWidth = 76;
            int yHeight = ClientConfig.renderHealthRpBar == ClientConfig.HealthRPRenderType.BOTH ? 30 : 9;
            xPos = ClientConfig.healthBarWidgetPosition.positionX(guiWidth, barWidth, ClientConfig.healthBarWidgetX) + 1;
            yPos = ClientConfig.healthBarWidgetPosition.positionY(guiHeight, yHeight, ClientConfig.healthBarWidgetY) + 1;
            if (data != null && !this.mc.player.isCreative()) {
                if (ClientConfig.renderHealthRpBar == ClientConfig.HealthRPRenderType.BOTH) {
                    graphics.blitSprite(HEALTH_BAR_BACKGROUND, xPos, yPos, barWidth, 9);
                    int healthWidth = Math.min(barWidth, (int)(this.mc.player.getHealth() / this.mc.player.getMaxHealth() * (float)barWidth));
                    GuiUtils.drawBorderedBar(graphics, HEALTH_BAR, xPos, yPos, barWidth, 9, healthWidth, 1, 1);
                    yPos += 12;
                }
                graphics.blitSprite(RUNEPOINTS_BAR_BACKGROUND, xPos, yPos, barWidth, 9);
                int runePointsWidth = Math.min(barWidth, (int)((float)data.getRunePoints() / (float)data.getMaxRunePoints() * (float)barWidth));
                GuiUtils.drawBorderedBar(graphics, RUNEPOINTS_BAR, xPos, yPos, barWidth, 9, runePointsWidth, 1, 1);
            }
        }
        if (ClientConfig.renderCalendar) {
            Calendar calendar = ClientCalendarHolder.CLIENT_CALENDAR;
            Season season = calendar.currentSeason();
            xPos = ClientConfig.seasonDisplayPosition.positionX(guiWidth, 64, ClientConfig.seasonDisplayX);
            yPos = ClientConfig.seasonDisplayPosition.positionY(guiHeight, 51, ClientConfig.seasonDisplayY);
            graphics.blitSprite(DATE.get((Object)season), xPos, yPos, 64, 32);
            GuiGraphicsExtension.drawCenteredString(graphics, this.mc.font, (Component)Component.translatable((String)"runecraftory.gui.date.format", (Object[])new Object[]{Component.translatable((String)calendar.date().day().translation()), calendar.date().date()}).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD}), (float)(xPos + 32), (float)(yPos + 15), 0, false);
            MutableComponent money = Component.literal((String)("" + data.getMoney())).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD});
            xPos = ClientConfig.seasonDisplayPosition.positionX(guiWidth, this.mc.font.width((FormattedText)money), ClientConfig.seasonDisplayX + 4);
            graphics.blitSprite(SpriteResources.MONEY_ICON, xPos, yPos += 36, 15, 15);
            graphics.drawString(this.mc.font, (Component)money, xPos + 20, yPos + 4, 0);
        }
    }
}

