/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.common.components.NPCSpawnData;
import io.github.flemmli97.runecraftory.common.entities.EnsembleMonsters;
import io.github.flemmli97.runecraftory.common.items.creative.NPCSpawnEgg;
import io.github.flemmli97.runecraftory.common.network.C2SSpawnEgg;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import io.github.flemmli97.tenshilib.client.gui.widget.SuggestionEditBox;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SpawnEggScreen
extends Screen {
    private final Player player;
    protected List<LivingEntity> entities;
    private final InteractionHand hand;
    private int leftPos;
    private int topPos;
    private final int sizeX = 240;
    private final int sizeY = 200;
    private final List<EditBox> editBoxes = new ArrayList<EditBox>();
    private EditBox levelEditor;
    private EditBox npcIDEditor;
    private int level;
    private ResourceLocation npcProfession;
    private ResourceLocation npcID;

    public SpawnEggScreen(InteractionHand hand) {
        super((Component)Component.literal((String)""));
        this.hand = hand;
        this.player = Minecraft.getInstance().player;
    }

    protected void init() {
        super.init();
        ItemStack stack = this.player.getItemInHand(this.hand);
        Item item = stack.getItem();
        if (!(item instanceof SpawnEgg)) {
            Minecraft.getInstance().setScreen(null);
            return;
        }
        SpawnEgg egg = (SpawnEgg)item;
        EntityType type = egg.getType(stack);
        Entity e = type.create((Level)Minecraft.getInstance().level);
        if (e instanceof EnsembleMonsters) {
            EnsembleMonsters ensemble = (EnsembleMonsters)e;
            ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
            for (Supplier<EntityType<?>> t : ensemble.entities()) {
                Entity sub = t.get().create((Level)Minecraft.getInstance().level);
                if (!(sub instanceof LivingEntity)) continue;
                LivingEntity livingSub = (LivingEntity)sub;
                livingSub.refreshDimensions();
                list.add(livingSub);
            }
            this.entities = List.copyOf(list);
        } else if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            living.refreshDimensions();
            this.entities = List.of(living);
        } else {
            Minecraft.getInstance().setScreen(null);
            return;
        }
        this.leftPos = this.width / 2 - this.sizeX / 2;
        this.topPos = this.height / 2 - this.sizeY / 2;
        this.buttons();
    }

    public void tick() {
        super.tick();
        this.entities.forEach(entity -> ++entity.tickCount);
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int padding;
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.fillGradient(this.leftPos, this.topPos, this.leftPos + this.sizeX, this.topPos + this.sizeY, -1072689136, -1072689136);
        int yOff = padding = 16;
        graphics.drawString(this.minecraft.font, (Component)Component.translatable((String)"runecraftory.gui.level"), this.leftPos + padding, this.topPos + yOff, 0xFFFFFF);
        if (this.npcIDEditor != null) {
            graphics.drawString(this.minecraft.font, (Component)Component.translatable((String)"runecraftory.gui.npc.profession"), this.leftPos + padding, this.topPos + (yOff += 72), 0xFFFFFF);
            graphics.drawString(this.minecraft.font, (Component)Component.translatable((String)"runecraftory.gui.npc.id"), this.leftPos + padding, this.topPos + (yOff += 36), 0xFFFFFF);
        }
        int max = Math.min(4, this.entities.size());
        for (int i = 0; i < max; ++i) {
            LivingEntity entity = this.entities.get(i);
            float scale = 1.0f;
            float size = 80.0f * scale;
            int posX = this.sizeX - padding - 12;
            int posY = padding + 12;
            if (max > 1) {
                int idx = i;
                if (max % 2 == 1) {
                    --idx;
                }
                int offset = (int)(Math.ceil(((double)idx + 1.0) / 2.0) * (double)(idx % 2 == 0 ? -1 : 1));
                int abs = Math.max(0, Math.abs(offset) - 1);
                scale = Math.max(0.2f, 1.0f - (float)abs * 0.3f);
                posX += offset * 30;
                posY -= abs * 15;
            }
            posX = (int)((float)posX - size);
            RenderUtils.renderScaledEntityGui((GuiGraphics)graphics, (float)(this.leftPos + posX), (float)(this.topPos + posY), (float)size, (float)size, (float)(30.0f * scale), (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)entity);
        }
    }

    protected void buttons() {
        this.editBoxes.clear();
        int padding = 16;
        int yOff = padding + 12;
        this.levelEditor = new EditBox(this, this.minecraft.font, this.leftPos + padding, this.topPos + yOff, 48, 16, (Component)Component.literal((String)"")){

            public boolean charTyped(char codePoint, int modifiers) {
                if (Character.isDigit(codePoint)) {
                    return super.charTyped(codePoint, modifiers);
                }
                return false;
            }
        };
        this.levelEditor.setResponder(s -> {
            try {
                this.level = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.editBoxes.add(this.levelEditor);
        ItemStack stack = this.player.getItemInHand(this.hand);
        this.level = (Integer)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.SPAWN_EGG_LEVEL.get(), (Object)1);
        this.levelEditor.setValue("" + this.level);
        this.addRenderableWidget((GuiEventListener)this.levelEditor);
        if (stack.getItem() instanceof NPCSpawnEgg) {
            SuggestionEditBox npcProfessionEditor = new SuggestionEditBox(this.minecraft.font, this.leftPos + padding, this.topPos + (yOff += 72), 130, 16, (Component)Component.literal((String)""), 5, false, SuggestionEditBox.ofResourceLocation((Collection)RuneCraftoryNPCProfessions.PROFESSIONS.registry().keySet()));
            NPCSpawnData itemData = (NPCSpawnData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.NPC_SPAWN_DATA.get(), (Object)NPCSpawnData.DEFAULT);
            this.npcProfession = itemData.profession().map(h -> ((ResourceKey)h.unwrapKey().orElseThrow()).location()).orElse(null);
            if (this.npcProfession != null) {
                npcProfessionEditor.setValue(this.npcProfession.toString());
            }
            npcProfessionEditor.setResponder(s -> {
                try {
                    this.npcProfession = s.isEmpty() ? null : ResourceLocation.parse((String)s);
                }
                catch (ResourceLocationException resourceLocationException) {
                    // empty catch block
                }
            });
            this.addRenderableWidget((GuiEventListener)npcProfessionEditor);
            this.editBoxes.add((EditBox)npcProfessionEditor);
            this.npcIDEditor = new EditBox(this.minecraft.font, this.leftPos + padding, this.topPos + (yOff += 36), this.sizeX - padding * 2, 16, (Component)Component.literal((String)""));
            this.npcID = itemData.npcDataId().orElse(null);
            if (this.npcID != null) {
                this.npcIDEditor.setValue(this.npcID.toString());
            }
            this.npcIDEditor.setResponder(s -> {
                try {
                    this.npcID = s.isEmpty() ? null : ResourceLocation.parse((String)s);
                }
                catch (ResourceLocationException resourceLocationException) {
                    // empty catch block
                }
            });
            this.addRenderableWidget((GuiEventListener)this.npcIDEditor);
            this.editBoxes.add(this.npcIDEditor);
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"runecraftory.gui.save"), b -> {
            LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpawnEgg(this.hand, this.level, this.npcProfession, this.npcID));
            this.minecraft.setScreen(null);
        }).bounds(this.leftPos + this.sizeX / 2 - 50, this.topPos + this.sizeY - 32, 100, 20).build());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.editBoxes.stream().noneMatch(EditBox::canConsumeInput) && this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean click = super.mouseClicked(mouseX, mouseY, button);
        if (!click) {
            this.setFocused(null);
        }
        return click;
    }
}

