/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.RuneCraftory;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class SpeechBubble
implements Renderable {
    protected static final ResourceLocation SPRITE = RuneCraftory.modRes("hud/speech_bubble");
    private final Minecraft mc;
    private final int x;
    private final int y;
    private final int width;
    private final int maxHeight;
    private int height;
    private int showDuration;
    private List<FormattedCharSequence> texts;

    public SpeechBubble(Minecraft mc, int x, int y, int width, int maxHeight) {
        this.mc = mc;
        this.x = x;
        this.y = y;
        this.width = width;
        this.maxHeight = maxHeight;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (--this.showDuration > 0 && this.texts != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SPRITE);
            graphics.blitSprite(SPRITE, this.x, this.y, this.width, this.height);
            int y = this.y + 7;
            for (FormattedCharSequence text : this.texts) {
                graphics.drawString(this.mc.font, text, this.x + 7, y, -1, false);
                Objects.requireNonNull(this.mc.font);
                y += 9;
            }
        }
    }

    public void showBubble(Component text, int duration) {
        this.showDuration = duration;
        this.texts = this.mc.font.split((FormattedText)text, this.width - 14);
        int n = this.texts.size() + 1;
        Objects.requireNonNull(this.mc.font);
        this.height = Math.min(n * 9, this.maxHeight) + 14;
    }
}

