/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.client.model.HumanoidBasedModel;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveStateHolder;
import io.github.flemmli97.runecraftory.mixinhelper.HumanoidMainHand;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AnimatedPlayerModel<T extends LivingEntity & MoveStateHolder>
extends HumanoidBasedModel<T> {
    public boolean setUpModel(Player entity, @Nullable HumanoidModel<?> model, AnimationHandler<?> handler, float partialTicks) {
        if (model != null) {
            HumanoidMainHand hands = (HumanoidMainHand)model;
            hands.runecraftory$getLeftHandItem().resetAll();
            hands.runecraftory$getRightHandItem().resetAll();
        }
        if (handler == null) {
            return false;
        }
        this.copyFrom((EntityModel<?>)model);
        return this.doAnimation(handler, partialTicks, entity.getMainArm() == HumanoidArm.LEFT);
    }

    private boolean doAnimation(AnimationHandler<?> handler, float partialTicks, boolean mirror) {
        boolean changed = ((BedrockAnimations)this.attackAnimations.get()).doAnimation((ExtendedModel)this, handler, partialTicks, mirror);
        if (changed && this.riding) {
            this.body.x = this.body.getDefaultPose().x;
            this.body.y = this.body.getDefaultPose().y;
            this.body.z = this.body.getDefaultPose().z;
            PoseStack stack = new PoseStack();
            this.body.translateAndRotate(stack);
            Vector3f v = this.bodyVehicleOffset != null ? new Vector3f((Vector3fc)this.bodyVehicleOffset) : new Vector3f();
            v.mulTranspose((Matrix3fc)stack.last().normal());
            this.body.x -= v.x() - this.bodyVehicleOffset.x;
            this.body.y -= v.y() - this.bodyVehicleOffset.y;
            this.body.z -= v.z() - this.bodyVehicleOffset.z;
        }
        return changed;
    }

    public void copyTo(HumanoidModel<?> model) {
        this.copyPropertiesTo(model);
    }

    @Override
    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }
}

