/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.TransformationHelper;
import io.github.flemmli97.runecraftory.client.model.HumanoidModelLocations;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveStateHolder;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.runecraftory.mixinhelper.HumanoidMainHand;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.DeformationChange;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ItemHolderModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HumanoidBasedModel<T extends LivingEntity & MoveStateHolder>
extends EntityModel<T>
implements ItemHolderModel,
HeadedModel,
ExtendedModel {
    protected final ReloadableCache<ModelPartsContainer> model;
    protected final ReloadableCache<BedrockAnimations> attackAnimations;
    protected final ReloadableCache<BedrockAnimations> miscAnimations;
    public ModelPartsContainer.ModelPartExtended head;
    public ModelPartsContainer.ModelPartExtended body;
    public ModelPartsContainer.ModelPartExtended rightArm;
    public ModelPartsContainer.ModelPartExtended rightItem;
    public ModelPartsContainer.ModelPartExtended leftArm;
    public ModelPartsContainer.ModelPartExtended leftItem;
    @Nullable
    public ModelPartsContainer.ModelPartExtended legBase;
    public ModelPartsContainer.ModelPartExtended rightLeg;
    public ModelPartsContainer.ModelPartExtended leftLeg;
    @Nullable
    public ModelPartsContainer.ModelPartExtended vehicleAttachment;
    protected Vector3f bodyVehicleOffset = new Vector3f(0.0f, -12.0f, 0.0f);
    protected final ModelPart dummyHead = new ModelPart(new ArrayList(), new HashMap());
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;
    public boolean crouching;
    private float partialTicks;
    protected HumanoidModel<T> delegate;

    public HumanoidBasedModel() {
        this(HumanoidModelLocations.DEFAULT_PLAYER_LOCATION, HumanoidModelLocations.DEFAULT_NPC_ANIMATION, 0.0f);
    }

    public HumanoidBasedModel(ResourceLocation modelLocation, ResourceLocation animationLocation, float inflate) {
        super(RenderType::entityTranslucent);
        this.model = GeoModelManager.getInstance().getModel(modelLocation, inflate != 0.0f ? new DeformationChange(inflate) : DeformationChange.NONE, model -> {
            this.head = model.getPart("Head");
            this.body = model.getPart("Body");
            this.rightItem = model.getPart("RightItemRoot");
            this.leftItem = model.getPart("LeftItemRoot");
            this.rightArm = model.getPart("RightArm");
            this.leftArm = model.getPart("LeftArm");
            this.legBase = model.getOptionalPart("LegsBase").orElse(null);
            this.rightLeg = model.getPart("RightLeg");
            this.leftLeg = model.getPart("LeftLeg");
            this.vehicleAttachment = model.getOptionalPart("VehicleAttachment").orElse(null);
            if (this.vehicleAttachment != null) {
                this.vehicleAttachment.updateDefaultPose(this.vehicleAttachment.getDefaultPose().withScale(0.0f, 0.0f, 0.0f));
                PoseExtended bodyPose = this.body.getDefaultPose();
                PoseExtended attachmentPose = this.vehicleAttachment.getDefaultPose();
                this.bodyVehicleOffset = new Vector3f(attachmentPose.x - bodyPose.x, attachmentPose.y - bodyPose.y, attachmentPose.z - bodyPose.z);
            }
        });
        this.attackAnimations = GeoAnimationManager.getInstance().getAnimation(HumanoidModelLocations.DEFAULT_PLAYER_LOCATION);
        this.miscAnimations = GeoAnimationManager.getInstance().getOptionalAnimation(animationLocation);
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    public void transform(HumanoidArm hand, PoseStack stack) {
        if (hand == HumanoidArm.LEFT) {
            this.leftItem.translateAndRotateWithParents(stack);
        } else {
            this.rightItem.translateAndRotateWithParents(stack);
        }
        stack.translate(0.0, 0.125, -0.125);
    }

    public ModelPart getHead() {
        this.dummyHead.x = this.head.x;
        this.dummyHead.y = this.head.y;
        this.dummyHead.z = this.head.z;
        this.dummyHead.xRot = this.head.xRot;
        this.dummyHead.yRot = this.head.yRot;
        this.dummyHead.zRot = this.head.zRot;
        this.dummyHead.xScale = this.head.xScale;
        this.dummyHead.yScale = this.head.yScale;
        this.dummyHead.zScale = this.head.zScale;
        return this.dummyHead;
    }

    public void setDelegate(HumanoidModel<T> delegate) {
        this.delegate = delegate;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        this.partialTicks = partialTick;
        if (this.delegate != null) {
            this.delegate.attackTime = this.attackTime;
            this.delegate.riding = this.riding;
            this.delegate.young = this.young;
            this.delegate.leftArmPose = this.leftArmPose;
            this.delegate.rightArmPose = this.rightArmPose;
            this.delegate.crouching = this.crouching;
            this.delegate.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.preAnimSetup(entity, limbSwing, limbSwingAmount, netHeadYaw, ageInTicks, headPitch);
        PoseExtended ext = null;
        PoseExtended ext2 = null;
        if (this.riding) {
            ext = this.leftLeg.extendedPose();
            ext2 = this.rightLeg.extendedPose();
        }
        ((BedrockAnimations)this.attackAnimations.get()).doAnimation((ExtendedModel)this, ((AnimatedEntity)entity).getAnimationHandler(), this.partialTicks, entity.getMainArm() == HumanoidArm.LEFT);
        if (this.delegate != null) {
            this.copyPropertiesTo((EntityModel<T>)this.delegate);
        }
        if (this.riding) {
            this.body.x = this.body.getDefaultPose().x;
            this.body.y = this.body.getDefaultPose().y;
            this.body.z = this.body.getDefaultPose().z;
            PoseStack stack = new PoseStack();
            this.body.translateAndRotate(stack);
            Vector3f v = this.bodyVehicleOffset != null ? new Vector3f((Vector3fc)this.bodyVehicleOffset) : new Vector3f();
            v.mulTranspose((Matrix3fc)stack.last().normal());
            this.body.x += v.x() - this.bodyVehicleOffset.x;
            this.body.y += v.y() - this.bodyVehicleOffset.y;
            this.body.z += v.z() - this.bodyVehicleOffset.z;
            this.leftLeg.loadPose(ext);
            this.rightLeg.loadPose(ext2);
        }
    }

    protected void preAnimSetup(T entity, float limbSwing, float limbSwingAmount, float netHeadYaw, float ageInTicks, float headPitch) {
        if (this.delegate != null) {
            this.delegate.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.copyFrom((EntityModel<?>)this.delegate);
        }
        BedrockAnimations animation = (BedrockAnimations)this.attackAnimations.get();
        HumanoidBasedModel.setupAnimationValues(this, animation, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
        BedrockAnimations miscAnimation = (BedrockAnimations)this.miscAnimations.get();
        HumanoidBasedModel.setupAnimationValues(this, animation, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
        miscAnimation.doAnimation((ExtendedModel)this, "idle", ((LivingEntity)entity).tickCount, this.partialTicks, 1.0f);
        miscAnimation.doAnimation((ExtendedModel)this, "walk", ((LivingEntity)entity).tickCount, this.partialTicks, ((MoveStateHolder)entity).interpolatedMoveTick(this.partialTicks));
        miscAnimation.doAnimation((ExtendedModel)this, "run", ((LivingEntity)entity).tickCount, this.partialTicks, ((MoveStateHolder)entity).interpolatedMoveTickOf(MoveType.RUN, this.partialTicks));
        miscAnimation.doAnimation((ExtendedModel)this, "swim", ((LivingEntity)entity).tickCount, this.partialTicks, entity.getSwimAmount(this.partialTicks));
        if (this.crouching) {
            miscAnimation.doAnimation((ExtendedModel)this, "crouching", ((LivingEntity)entity).tickCount, this.partialTicks, 1.0f, false, true);
        }
        if (this.riding) {
            miscAnimation.doAnimation((ExtendedModel)this, "riding", ((LivingEntity)entity).tickCount, this.partialTicks, 1.0f);
        }
    }

    public static void setupAnimationValues(HumanoidBasedModel<?> model, BedrockAnimations animation, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch) {
        animation.setVariable("query.head_x_rotation", () -> headPitch);
        animation.setVariable("query.head_y_rotation", () -> netHeadYaw);
        animation.setVariable("left_held", () -> model.leftArmPose != HumanoidModel.ArmPose.EMPTY ? 1.0 : 0.0);
        animation.setVariable("left_arm_x_rot", () -> model.leftArm != null ? (double)(model.leftArm.xRot * 57.295776f) : 0.0);
        animation.setVariable("right_held", () -> model.rightArmPose != HumanoidModel.ArmPose.EMPTY ? 1.0 : 0.0);
        animation.setVariable("right_arm_x_rot", () -> model.rightArm != null ? (double)(model.rightArm.xRot * 57.295776f) : 0.0);
        animation.setVariable("limb_swing", () -> limbSwing * 57.295776f);
        animation.setVariable("limb_swing_amount", () -> limbSwingAmount * 57.295776f);
        animation.setVariable("crouching", () -> model.crouching ? 1.0 : 0.0);
        animation.setVariable("riding", () -> model.riding ? 1.0 : 0.0);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        ((ModelPartsContainer)this.model.get()).getRoot().renderForced(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void copyFrom(@Nullable EntityModel<?> model) {
        this.getModel().resetPoses();
        if (model == null) {
            return;
        }
        model.copyPropertiesTo((EntityModel)this);
        if (model instanceof HumanoidModel) {
            HumanoidModel other = (HumanoidModel)model;
            PartPose body = other.body.storePose();
            this.body.loadPose(body);
            this.leftArm.loadPose(TransformationHelper.withoutParent(body, other.leftArm.storePose()));
            this.rightArm.loadPose(TransformationHelper.withoutParent(body, other.rightArm.storePose()));
            this.leftLeg.loadPose(TransformationHelper.withoutParent(body, other.leftLeg.storePose()));
            this.rightLeg.loadPose(TransformationHelper.withoutParent(body, other.rightLeg.storePose()));
            this.head.loadPose(TransformationHelper.withoutParent(body, other.head.storePose()));
        }
    }

    public void copyPropertiesTo(EntityModel<T> model) {
        HumanoidBasedModel other;
        super.copyPropertiesTo(model);
        if (model instanceof HumanoidBasedModel) {
            other = (HumanoidBasedModel)model;
            other.getModel().getRoot().forEach((name, part) -> this.getModel().getOptionalPart(name).ifPresentOrElse(p -> part.loadPose(p.extendedPose()), () -> ((ModelPartsContainer.ModelPartExtended)part).reset()));
        }
        if (model instanceof HumanoidModel) {
            other = (HumanoidModel)model;
            PoseExtended body = this.body.extendedPose();
            ((HumanoidModel)other).body.visible = this.body.visible;
            ((HumanoidModel)other).body.loadPose(body.asPartPose());
            ((HumanoidModel)other).head.visible = this.head.visible;
            this.apply(((HumanoidModel)other).head, body, this.head);
            ((HumanoidModel)other).leftArm.visible = this.leftArm.visible;
            this.apply(((HumanoidModel)other).leftArm, body, this.leftArm);
            HumanoidMainHand hands = (HumanoidMainHand)model;
            hands.runecraftory$getLeftHandItem().loadPose(this.leftItem.storePose());
            ((HumanoidModel)other).rightArm.visible = this.rightArm.visible;
            this.apply(((HumanoidModel)other).rightArm, body, this.rightArm);
            hands.runecraftory$getRightHandItem().loadPose(this.rightItem.storePose());
            if (!model.riding) {
                this.apply(((HumanoidModel)other).leftLeg, body, this.leftLeg);
                this.apply(((HumanoidModel)other).rightLeg, body, this.rightLeg);
            } else {
                ((HumanoidModel)other).leftLeg.loadPose(TransformationHelper.withParent(body, ((HumanoidModel)other).leftLeg.storePose()));
                ((HumanoidModel)other).rightLeg.loadPose(TransformationHelper.withParent(body, ((HumanoidModel)other).rightLeg.storePose()));
            }
            ((HumanoidModel)other).leftLeg.visible = this.leftLeg.visible;
            ((HumanoidModel)other).rightLeg.visible = this.rightLeg.visible;
            ((HumanoidModel)other).hat.visible = ((HumanoidModel)other).head.visible;
            ((HumanoidModel)other).hat.copyFrom(((HumanoidModel)other).head);
        }
    }

    private void apply(ModelPart model, PoseExtended body, ModelPartsContainer.ModelPartExtended first) {
        model.loadPose(TransformationHelper.withParent(body, first.storePose()));
    }

    public void setAllVisible(boolean visible) {
        this.getModel().getRoot().forEach((name, part) -> {
            part.visible = visible;
        });
    }

    public void copyVisibilityFrom(HumanoidBasedModel<T> model) {
        model.getModel().getRoot().forEach((name, part) -> this.getModel().getOptionalPart(name).ifPresentOrElse(p -> {
            p.visible = part.visible;
        }, () -> ((ModelPartsContainer.ModelPartExtended)part).reset()));
    }
}

