/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.Rafflesia;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.RafflesiaPart;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RafflesiaModel<T extends Rafflesia>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ResourceLocation LOCATION = RuneCraftory.modRes("entity/rafflesia");
    private final ReloadableCache<ModelPartsContainer> model = GeoModelManager.getInstance().getModel(LOCATION, model -> {
        this.mainRoot = model.getPart("mainRoot");
        this.head = model.getPart("head");
        this.horseTail = model.getPart("leftStem");
        this.pitcher = model.getPart("rightStem");
        this.flower = model.getPart("frontStem");
        this.ridingPosition = model.getPart("ridingPos");
    });
    protected final ReloadableCache<BedrockAnimations> anim = GeoAnimationManager.getInstance().getAnimation(LOCATION);
    public ModelPartsContainer.ModelPartExtended mainRoot;
    public ModelPartsContainer.ModelPartExtended head;
    public ModelPartsContainer.ModelPartExtended horseTail;
    public ModelPartsContainer.ModelPartExtended pitcher;
    public ModelPartsContainer.ModelPartExtended flower;
    public ModelPartsContainer.ModelPartExtended ridingPosition;

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.getModel().getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        RafflesiaPart horseTail;
        this.getModel().resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        this.mainRoot.yRot = (Mth.lerp((float)partialTicks, (float)((Rafflesia)entity).yHeadRotO, (float)((Rafflesia)entity).yHeadRot) - ((Rafflesia)entity).getSpawnDirection().toYRot()) * ((float)Math.PI / 180);
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.3f;
        AnimationState current = ((Rafflesia)entity).getAnimationHandler().getAnimation();
        if (!(((Rafflesia)entity).deathTime > 0 || ((BaseMonster)entity).playDeath() || current != null && current.getAnimation().equals("breath"))) {
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "idle", ((Rafflesia)entity).tickCount, partialTicks);
        }
        ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, ((Rafflesia)entity).getAnimationHandler(), partialTicks, s -> Rafflesia.isMirrorAttack(s.definition()), null);
        if (current == null || current.getAnimation().equals("breath")) {
            this.head.xRot += headPitch * ((float)Math.PI / 180) * 1.0f;
        }
        if ((horseTail = ((Rafflesia)entity).getHorseTail()) != null) {
            this.horseTail.visible = true;
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, horseTail.getAnimationHandler(), partialTicks);
        } else {
            this.horseTail.visible = false;
        }
        RafflesiaPart flower = ((Rafflesia)entity).getFlower();
        if (flower != null) {
            this.flower.visible = true;
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, flower.getAnimationHandler(), partialTicks);
        } else {
            this.flower.visible = false;
        }
        RafflesiaPart pitcher = ((Rafflesia)entity).getPitcher();
        if (pitcher != null) {
            this.pitcher.visible = true;
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, pitcher.getAnimationHandler(), partialTicks);
        } else {
            this.pitcher.visible = false;
        }
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        this.ridingPosition.translateAndRotateWithParents(poseStack);
        ClientHandlers.translateRider(poseStack, entity, rider);
        return true;
    }
}

