/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.model.monster.WoolyModel;
import io.github.flemmli97.runecraftory.client.model.monster.WoolyWoolModel;
import io.github.flemmli97.runecraftory.common.entities.monster.Wooly;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class LayerWooly<T extends Wooly>
extends RenderLayer<T, WoolyModel<T>> {
    private final ResourceLocation tex = RuneCraftory.modRes("textures/entity/monsters/wooly_wool.png");
    private final WoolyWoolModel<T> woolModel;

    public LayerWooly(RenderLayerParent<T, WoolyModel<T>> renderer, WoolyWoolModel<T> woolModel) {
        super(renderer);
        this.woolModel = woolModel;
    }

    public void render(PoseStack stack, MultiBufferSource buf, int light, T wooly, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((Wooly)wooly).isSheared() && !wooly.isInvisible()) {
            int color = -1;
            if (wooly.hasCustomName() && "jeb_".equals(wooly.getName().getString())) {
                int tick = ((Wooly)wooly).tickCount / 25 + wooly.getId();
                int colorCount = DyeColor.values().length;
                int l = tick % colorCount;
                int m = (tick + 1) % colorCount;
                float f = ((float)(((Wooly)wooly).tickCount % 25) + partialTicks) / 25.0f;
                int n = Sheep.getColor((DyeColor)DyeColor.byId((int)l));
                int o = Sheep.getColor((DyeColor)DyeColor.byId((int)m));
                color = FastColor.ARGB32.lerp((float)f, (int)n, (int)o);
            }
            this.woolModel.syncModel((WoolyModel)this.getParentModel());
            LayerWooly.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.woolModel, (ResourceLocation)this.tex, (PoseStack)stack, (MultiBufferSource)buf, (int)light, wooly, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (int)color);
        }
    }
}

