/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.model.monster.SpiderModel;
import io.github.flemmli97.runecraftory.client.render.RenderMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.Spider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class SpiderRender<T extends Spider>
extends RenderMonster<T, SpiderModel<T>> {
    public SpiderRender(EntityRendererProvider.Context ctx) {
        super(ctx, new SpiderModel(), RuneCraftory.modRes("textures/entity/monsters/spider.png"), 0.7f);
    }

    @Override
    protected void setupRotations(T entity, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations(entity, stack, ageInTicks, rotationYaw, partialTicks, scale);
        if (((Spider)entity).climbingTicker >= 0) {
            float f = ((float)((Spider)entity).climbingTicker + (((Spider)entity).isClimbing() ? partialTicks : -partialTicks)) / 9.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            stack.mulPose(Axis.XP.rotationDegrees(f * 90.0f));
            stack.translate(0.0, -0.8 * (double)f, -0.2 * (double)f);
        }
    }
}

