/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.model.HumanoidBasedModel;
import io.github.flemmli97.runecraftory.client.model.HumanoidModelLocations;
import io.github.flemmli97.runecraftory.client.render.npc.NPCArmorLayer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFaceLayer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFeatureRenderLayer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFeatureRenderers;
import io.github.flemmli97.runecraftory.client.render.npc.NPCModelHolder;
import io.github.flemmli97.runecraftory.client.render.npc.NPCTextureLayer;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ModelFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.entities.npc.features.OutfitFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SimpleHatFeatureType;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.github.flemmli97.tenshilib.client.render.layer.ItemLayer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.Nullable;

public class NPCRender<T extends NPCEntity>
extends MobRenderer<T, HumanoidBasedModel<T>> {
    private static final Map<String, PlayerSkinData> PLAYER_SKIN_TEXTURE_LOCATIONS = new HashMap<String, PlayerSkinData>();
    private static final Map<String, ResourceLocation> TEXTURE_LAYERS_LOCATIONS = new HashMap<String, ResourceLocation>();
    public static final ResourceLocation EMPTY = RuneCraftory.modRes("textures/entity/npc/empty.png");
    public final NPCArmorLayer<T> armorLayer;
    public final List<NPCTextureLayer<T>> textureLayers = new ArrayList<NPCTextureLayer<T>>();
    private final HumanoidModel<T> internalHumanoid;
    private final Map<Pair<ResourceLocation, ResourceLocation>, NPCModelHolder> models = new HashMap<Pair<ResourceLocation, ResourceLocation>, NPCModelHolder>();
    private NPCModelHolder current;

    public NPCRender(EntityRendererProvider.Context ctx) {
        super(ctx, new HumanoidBasedModel(), 0.5f);
        this.internalHumanoid = new HumanoidModel(ctx.bakeLayer(ModelLayers.PLAYER));
        this.armorLayer = new NPCArmorLayer(this, new RenderLayerParent<T, HumanoidModel<T>>(){

            public HumanoidModel<T> getModel() {
                return NPCRender.this.internalHumanoid;
            }

            public ResourceLocation getTextureLocation(T entity) {
                return NPCRender.this.getTextureLocation(entity);
            }
        }, ctx);
        this.addLayer(this.armorLayer);
        this.addLayer((RenderLayer)new ItemLayer((RenderLayerParent)this, ctx.getItemInHandRenderer()));
        this.current = this.getModelHolder(HumanoidModelLocations.DEFAULT_LOCATION);
        this.getModelHolder(HumanoidModelLocations.DEFAULT_LOCATION_SLIM);
        for (NPCTextureLayer.LayerType layerType : NPCTextureLayer.LayerType.values()) {
            if (layerType.modelType == null) continue;
            if (layerType == NPCTextureLayer.LayerType.IRIS_LAYER) {
                this.textureLayers.add(new NPCFaceLayer(this));
                continue;
            }
            this.textureLayers.add(new NPCTextureLayer(this, layerType));
        }
        this.textureLayers.forEach(arg_0 -> ((NPCRender)this).addLayer(arg_0));
        this.addLayer(new NPCFeatureRenderLayer(this));
    }

    public static boolean isSlim(NPCEntity npc) {
        NPCLook look = npc.getLook().value();
        if (look == NPCLook.DEFAULT.value()) {
            return DefaultPlayerSkin.get((UUID)npc.getUUID()).model() == PlayerSkin.Model.SLIM;
        }
        String skin = look.playerSkin();
        if (skin != null) {
            PlayerSkin.Model skinMeta = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkinData(skin)).getSkinMeta();
            return skinMeta == PlayerSkin.Model.SLIM;
        }
        return npc.lookFeatures.contains((NPCFeatureType)RuneCraftoryNPCLooks.SLIM.get());
    }

    public static ResourceLocation getTextureFromLook(NPCEntity npc, NPCTextureLayer.LayerType type, @Nullable String subType) {
        NPCLook look = npc.getLook().value();
        if (type == NPCTextureLayer.LayerType.SKIN_LAYER) {
            if (look == NPCLook.DEFAULT.value()) {
                return DefaultPlayerSkin.get((UUID)npc.getUUID()).texture();
            }
            String skin = look.playerSkin();
            if (skin != null) {
                return PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkinData(skin)).getLocation();
            }
        } else if (look.playerSkin() != null || look == NPCLook.DEFAULT.value()) {
            return EMPTY;
        }
        boolean slim = NPCRender.isSlim(npc);
        if (type == NPCTextureLayer.LayerType.HAT_LAYER && npc.hasItemInSlot(EquipmentSlot.HEAD)) {
            return EMPTY;
        }
        return NPCRender.getTextureFromLook(npc.lookFeatures, slim, type, subType);
    }

    public static ResourceLocation getTextureFromLook(NPCFeatureContainer features, boolean slim, NPCTextureLayer.LayerType type, @Nullable String subType) {
        ResourceLocation texture;
        ModelFeatureType.ModelFeature modelFeature = (ModelFeatureType.ModelFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get());
        String prefix = null;
        if (modelFeature != null) {
            prefix = modelFeature.model().map(ModelFeatureType.ModelData::layerPrefix).orElse(null);
            texture = modelFeature.model().flatMap(ModelFeatureType.ModelData::texture).orElse(null);
            if (texture != null) {
                if (type != NPCTextureLayer.LayerType.SKIN_LAYER) {
                    return EMPTY;
                }
                return TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(texture.toString(), res -> texture.withPath(s -> "textures/" + s + ".png"));
            }
        }
        texture = switch (type) {
            default -> throw new MatchException(null, null);
            case NPCTextureLayer.LayerType.SKIN_LAYER -> {
                Record feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.SKIN.get());
                int num = 0;
                if (feat != null) {
                    num = ((IndexedColorSettingType.IndexedColorFeature)feat).index();
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/skin/", prefix, slim ? "slim" : "", num);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.IRIS_LAYER -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).iris().index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.IRIS);
                    }
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/eye/iris_", prefix, num, subType);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.SCLERA_LAYER -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).sclera().index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.SCLERA);
                    }
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/eye/sclera_", prefix, num, subType);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.EYEBROWS_LAYER -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).eyebrow().index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.EYEBROWS);
                    }
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/eye/eyebrows_", prefix, num, subType);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.BLUSH_LAYER -> {
                Record feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.BLUSH.get());
                if (feat == null || !((BlushFeatureType.BlushFeature)feat).blush()) {
                    yield null;
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/misc/blush", prefix);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.OUTFIT_LAYER -> {
                Record feat = (OutfitFeatureType.OutfitFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get());
                String location = String.format("textures/entity/npc/outfit/generic%s_0.png", slim ? "_slim" : "");
                if (feat != null) {
                    location = NPCRender.formatTextureTemplate("textures/entity/npc/outfit/", ((OutfitFeatureType.OutfitFeature)feat).outfit(), slim ? "slim" : "", ((OutfitFeatureType.OutfitFeature)feat).index());
                }
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.HAIR_LAYER -> {
                Record feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get());
                if (feat == null) {
                    yield null;
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/hair/", prefix, ((HairFeatureType.HairFeature)feat).hair(), ((HairFeatureType.HairFeature)feat).index());
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.HAT_LAYER -> {
                Record feat = (SimpleHatFeatureType.SimpleHatFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAT.get());
                if (feat == null || ((SimpleHatFeatureType.SimpleHatFeature)feat).hat().isEmpty()) {
                    yield null;
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/misc/", ((SimpleHatFeatureType.SimpleHatFeature)feat).hat());
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
        };
        return texture == null ? EMPTY : texture;
    }

    private static String formatTextureTemplate(String format, Object ... args) {
        StringBuilder formatBuilder = new StringBuilder(format);
        ArrayList<CallSite> formatArgs = new ArrayList<CallSite>();
        int idx = 0;
        for (Object arg : args) {
            String argRep;
            if (arg == null || (argRep = arg.toString()).isEmpty()) continue;
            formatBuilder.append("%s");
            formatArgs.add((CallSite)((Object)((idx != 0 ? "_" : "") + argRep)));
            ++idx;
        }
        return String.format(formatBuilder.append(".png").toString(), formatArgs.toArray());
    }

    public static boolean renderForTooltip(GuiGraphics graphics, int x, int y, @Nullable String skin, List<Pair<Integer, ResourceLocation>> textures) {
        if (skin == null && textures == null) {
            return false;
        }
        int sizeX = 16;
        int sizeY = 16;
        if (skin != null) {
            ResourceLocation res = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkinData(skin)).getLocation();
            graphics.blit(res, x, y, sizeX, sizeY, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.enableBlend();
            graphics.blit(res, x, y, sizeX, sizeY, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
        } else {
            for (Pair<Integer, ResourceLocation> layer : textures) {
                int color = (Integer)layer.getFirst();
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                graphics.blit((ResourceLocation)layer.getSecond(), x, y, sizeX, sizeY, 8.0f, 8.0f, 8, 8, 64, 64);
                RenderSystem.enableBlend();
                graphics.blit((ResourceLocation)layer.getSecond(), x, y, sizeX, sizeY, 40.0f, 8.0f, 8, 8, 64, 64);
                RenderSystem.disableBlend();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    protected boolean shouldShowName(T entity) {
        return false;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        boolean slim = NPCRender.isSlim(entity);
        this.updateModelFromEntity(entity, slim);
        ((HumanoidBasedModel)this.getModel()).setDelegate(this.internalHumanoid);
        this.armorLayer.setSlim(slim);
        this.setModelProperties((NPCEntity)entity);
        for (NPCFeature feature : ((NPCEntity)entity).lookFeatures) {
            NPCFeatureRenderers.get(feature).onSetup(feature, this, entity, stack);
        }
        super.render(entity, entityYaw, partialTicks, stack, buffer, packedLight);
    }

    protected void updateModelFromEntity(T entity, boolean slim) {
        this.current = this.getModelHolder(this.getModelLocation(entity, slim));
        this.model = this.current.get(NPCTextureLayer.ModelType.SKIN_LAYER);
    }

    protected Pair<ResourceLocation, ResourceLocation> getModelLocation(T entity, boolean slim) {
        ModelFeatureType.ModelFeature modelFeature = (ModelFeatureType.ModelFeature)((NPCEntity)entity).lookFeatures.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get());
        ResourceLocation model = slim ? HumanoidModelLocations.DEFAULT_LOCATION_SLIM : HumanoidModelLocations.DEFAULT_LOCATION;
        ResourceLocation animation = null;
        if (modelFeature != null) {
            ModelFeatureType.ModelData modelData = modelFeature.model().orElse(null);
            if (modelData != null) {
                model = modelData.model();
            }
            if (modelFeature.animation().isPresent()) {
                animation = modelFeature.animation().get();
            }
        }
        return Pair.of((Object)model, animation);
    }

    private NPCModelHolder getModelHolder(ResourceLocation model) {
        return this.getModelHolder((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)model, null));
    }

    protected NPCModelHolder getModelHolder(Pair<ResourceLocation, ResourceLocation> location) {
        return this.models.computeIfAbsent(location, key -> new NPCModelHolder(location));
    }

    protected NPCModelHolder getCurrent() {
        return this.current;
    }

    private void setModelProperties(NPCEntity npc) {
        HumanoidBasedModel currentModel = (HumanoidBasedModel)this.getModel();
        currentModel.setAllVisible(true);
        currentModel.crouching = npc.isCrouching();
        HumanoidModel.ArmPose main = NPCRender.getArmPose(npc, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose off = NPCRender.getArmPose(npc, InteractionHand.OFF_HAND);
        if (main.isTwoHanded()) {
            HumanoidModel.ArmPose armPose = off = npc.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (npc.getMainArm() == HumanoidArm.RIGHT) {
            currentModel.rightArmPose = main;
            currentModel.leftArmPose = off;
        } else {
            currentModel.rightArmPose = off;
            currentModel.leftArmPose = main;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(NPCEntity npc, InteractionHand hand) {
        ItemStack itemStack = npc.getItemInHand(hand);
        if (itemStack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (npc.getUsedItemHand() == hand && npc.getUseItemRemainingTicks() > 0) {
            UseAnim useAnim = itemStack.getUseAnimation();
            if (useAnim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useAnim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAnim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useAnim == UseAnim.CROSSBOW && hand == npc.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useAnim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!npc.swinging && itemStack.is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)itemStack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return NPCRender.getTextureFromLook(entity, NPCTextureLayer.LayerType.SKIN_LAYER, null);
    }

    protected void setupRotations(T entity, PoseStack stack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations(entity, stack, bob, yBodyRot, partialTick, scale);
        if (((NPCEntity)entity).getPlayDeathTick() > 0) {
            float f;
            float partial = partialTick - 1.0f;
            float f2 = ((float)((NPCEntity)entity).getPlayDeathTick() + (((NPCEntity)entity).playDeath() ? partial : -partial)) / 20.0f * 1.6f;
            f2 = Mth.sqrt((float)f2);
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            stack.translate(0.0, (double)f2 * 0.1, (double)(-f2 * entity.getBbHeight()) * 0.5);
            stack.mulPose(Axis.XP.rotationDegrees(f2 * this.getFlipDegrees((LivingEntity)entity)));
        }
        for (NPCFeature feature : ((NPCEntity)entity).lookFeatures) {
            NPCFeatureRenderers.get(feature).transformStack(feature, this, entity, stack, partialTick);
        }
    }

    protected void scale(T livingEntity, PoseStack matrixStack, float partialTickTime) {
        matrixStack.scale(0.9375f, 0.9375f, 0.9375f);
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean invis, boolean translucent, boolean glowing) {
        return null;
    }

    static class PlayerSkinData {
        private GameProfile gameProfile;
        private ResourceLocation location = DefaultPlayerSkin.getDefaultTexture();
        private PlayerSkin.Model skinMeta = PlayerSkin.Model.SLIM;
        private boolean pendingTextures;

        public PlayerSkinData(String name) {
            SkullBlockEntity.fetchGameProfile((String)name).thenAccept(prof -> prof.ifPresent(p -> {
                this.gameProfile = p;
            }));
        }

        public ResourceLocation getLocation() {
            this.registerTextures();
            return this.location;
        }

        public PlayerSkin.Model getSkinMeta() {
            this.registerTextures();
            return this.skinMeta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerTextures() {
            PlayerSkinData playerSkinData = this;
            synchronized (playerSkinData) {
                if (!this.pendingTextures && this.gameProfile != null) {
                    this.pendingTextures = true;
                    Minecraft.getInstance().getSkinManager().getOrLoad(this.gameProfile).thenAccept(skin -> {
                        this.location = skin.texture();
                        this.skinMeta = skin.model();
                    });
                }
            }
        }
    }
}

