/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.model.HumanoidBasedModel;
import io.github.flemmli97.runecraftory.client.render.npc.NPCRender;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ModelFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class NPCTextureLayer<T extends NPCEntity>
extends RenderLayer<T, HumanoidBasedModel<T>> {
    private final NPCRender<T> renderer;
    protected LayerType layer;

    public NPCTextureLayer(NPCRender<T> renderer, LayerType layer) {
        super(renderer);
        this.renderer = renderer;
        this.layer = layer;
    }

    public static int setColor(NPCEntity entity, LayerType layer) {
        if (layer == LayerType.SKIN_LAYER) {
            if (entity.getLook().value().playerSkin() != null) {
                return -1;
            }
            ModelFeatureType.ModelFeature modelFeature = (ModelFeatureType.ModelFeature)entity.lookFeatures.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get());
            if (modelFeature != null && modelFeature.model().flatMap(ModelFeatureType.ModelData::texture).orElse(null) != null) {
                return -1;
            }
        }
        return NPCTextureLayer.setColor(entity.lookFeatures, layer);
    }

    public static int setColor(NPCFeatureContainer features, LayerType layer) {
        int color = switch (layer.ordinal()) {
            case 0 -> {
                Record feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.SKIN.get());
                if (feat == null) {
                    yield 14008231;
                }
                yield ((IndexedColorSettingType.IndexedColorFeature)feat).color();
            }
            case 2 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).iris() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).iris().color();
            }
            case 3 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).sclera() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).sclera().color();
            }
            case 4 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).eyebrow() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).eyebrow().color();
            }
            case 5 -> {
                Record feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.BLUSH.get());
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((BlushFeatureType.BlushFeature)feat).color();
            }
            case 6 -> {
                Record feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get());
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((HairFeatureType.HairFeature)feat).color();
            }
            default -> 0xFFFFFF;
        };
        int a = 255;
        if (layer == LayerType.BLUSH_LAYER) {
            a = 88;
        }
        return a << 24 | color;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T npc, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        HumanoidBasedModel<T> layerModel = this.getModel();
        this.setup(layerModel);
        poseStack.pushPose();
        this.actualRender(poseStack, buffer, packedLight, npc, layerModel);
        poseStack.popPose();
    }

    protected HumanoidBasedModel<T> getModel() {
        return this.renderer.getCurrent().get(this.layer.modelType);
    }

    protected void setup(HumanoidBasedModel<T> layerModel) {
        ((HumanoidBasedModel)this.getParentModel()).copyPropertiesTo(layerModel);
        this.setPartVisibility(layerModel);
    }

    protected void actualRender(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T npc, HumanoidBasedModel<T> layerModel) {
        boolean bl3;
        boolean bl2;
        Minecraft mc = Minecraft.getInstance();
        boolean bl = !npc.isInvisible();
        RenderType renderType = this.getRenderType(npc, layerModel, bl, bl2 = !bl && !npc.isInvisibleTo((Player)mc.player), bl3 = mc.shouldEntityAppearGlowing(npc));
        if (renderType != null) {
            VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
            int m = LivingEntityRenderer.getOverlayCoords(npc, (float)0.0f);
            int color = this.setColor(npc);
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            layerModel.renderToBuffer(poseStack, vertexConsumer, packedLight, m, FastColor.ARGB32.colorFromFloat((float)(a * (bl2 ? 0.15f : 1.0f)), (float)r, (float)g, (float)b));
        }
    }

    @Nullable
    protected RenderType getRenderType(T entity, HumanoidBasedModel<T> model, boolean bodyVisible, boolean translucent, boolean glowing) {
        ResourceLocation resourceLocation;
        if (((NPCEntity)entity).getPlayDeathTick() > 0 && !((NPCEntity)entity).playDeath()) {
            if (((NPCEntity)entity).getPlayDeathTick() > 8 && ((NPCEntity)entity).getPlayDeathTick() % 2 == 0) {
                return null;
            }
            if (((NPCEntity)entity).getPlayDeathTick() % 3 == 0) {
                return null;
            }
        }
        if ((resourceLocation = this.getTexture(entity)).equals((Object)NPCRender.EMPTY)) {
            return null;
        }
        if (translucent) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourceLocation);
        }
        if (bodyVisible) {
            return model.renderType(resourceLocation);
        }
        if (glowing) {
            return RenderType.outline((ResourceLocation)resourceLocation);
        }
        return null;
    }

    protected int setColor(T entity) {
        return NPCTextureLayer.setColor(entity, this.layer);
    }

    protected ResourceLocation getTexture(T entity) {
        return NPCRender.getTextureFromLook(entity, this.layer, null);
    }

    protected void setPartVisibility(HumanoidBasedModel<T> model) {
        if (this.layer == LayerType.SKIN_LAYER) {
            return;
        }
        model.setAllVisible(false);
        model.head.visible = ((HumanoidBasedModel)this.renderer.getModel()).head.visible;
        switch (this.layer.ordinal()) {
            case 1: {
                model.copyVisibilityFrom((HumanoidBasedModel)this.renderer.getModel());
                break;
            }
            case 6: {
                model.body.visible = ((HumanoidBasedModel)this.renderer.getModel()).body.visible;
                model.rightArm.visible = ((HumanoidBasedModel)this.renderer.getModel()).rightArm.visible;
                model.leftArm.visible = ((HumanoidBasedModel)this.renderer.getModel()).leftArm.visible;
            }
        }
    }

    public static enum LayerType {
        SKIN_LAYER(ModelType.SKIN_LAYER),
        OUTFIT_LAYER(ModelType.OUTFIT_LAYER),
        IRIS_LAYER(ModelType.FACE_LAYER),
        SCLERA_LAYER(null),
        EYEBROWS_LAYER(null),
        BLUSH_LAYER(ModelType.BLUSH_LAYER),
        HAIR_LAYER(ModelType.HAIR_LAYER),
        HAT_LAYER(ModelType.HAT_LAYER);

        public final ModelType modelType;

        private LayerType(ModelType modelType) {
            this.modelType = modelType;
        }
    }

    public static enum ModelType {
        SKIN_LAYER(0.0f),
        OUTFIT_LAYER(0.005f),
        FACE_LAYER(0.006f),
        BLUSH_LAYER(0.009f),
        HAIR_LAYER(0.5f),
        HAT_LAYER(0.8f);

        public final float expand;

        private ModelType(float expand) {
            this.expand = expand;
        }
    }
}

