/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.misc.BigRaccoonLeafEntity;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.client.render.TextureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class BigRaccoonLeafRender
extends TextureRenderer<BigRaccoonLeafEntity> {
    private static final ResourceLocation TEX = RuneCraftory.modRes("textures/entity/projectile/leaf.png");

    public BigRaccoonLeafRender(EntityRendererProvider.Context ctx) {
        super(ctx, 0.8f, 0.8f, 1, 1);
    }

    public void render(BigRaccoonLeafEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        stack.translate(0.0, (double)this.ySize * 0.27, 0.05);
        float spin = entity.initialYaw() + Mth.lerp((float)packedLight, (float)(40 * entity.livingTicks()), (float)(40 * entity.livingTicks() + 1));
        stack.mulPose(Axis.YP.rotationDegrees(entity.spinRight() ? spin : -spin));
        super.render((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
        stack.popPose();
    }

    public void adjustYawPitch(PoseStack stack, BigRaccoonLeafEntity entity, float partialTicks, float yaw, float pitch) {
        super.adjustYawPitch(stack, (Entity)entity, partialTicks, 0.0f, 0.0f);
    }

    public void doRender(BigRaccoonLeafEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer) {
        stack.mulPose(Axis.XP.rotationDegrees(-20.0f));
        RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(this.getRenderType((Entity)entity, this.getTextureLocation(entity))), (float)this.xSize, (float)this.ySize, (RenderUtils.TextureBuilder)this.textureBuilder);
        stack.mulPose(Axis.XP.rotationDegrees(40.0f));
        RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(this.getRenderType((Entity)entity, this.getTextureLocation(entity))), (float)this.xSize, (float)this.ySize, (RenderUtils.TextureBuilder)this.textureBuilder);
    }

    public ResourceLocation getTextureLocation(BigRaccoonLeafEntity entity) {
        return TEX;
    }

    public boolean facePlayer() {
        return false;
    }

    public float yawOffset() {
        return -90.0f;
    }
}

