/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.common.entities.misc.CustomFishingHookEntity;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolFishingRod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class CustomFishingHookerRender
extends EntityRenderer<CustomFishingHookEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.parse((String)"textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout((ResourceLocation)TEXTURE_LOCATION);

    public CustomFishingHookerRender(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CustomFishingHookEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        double p;
        float o;
        double zPos;
        double yPos;
        double xPos;
        Entity eOwner = entity.getOwner();
        if (!(eOwner instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)eOwner;
        matrixStack.pushPose();
        matrixStack.pushPose();
        matrixStack.scale(0.5f, 0.5f, 0.5f);
        matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose pose = matrixStack.last();
        VertexConsumer vertexConsumer = buffer.getBuffer(RENDER_TYPE);
        CustomFishingHookerRender.vertex(vertexConsumer, pose, packedLight, 0.0f, 0, 0, 1);
        CustomFishingHookerRender.vertex(vertexConsumer, pose, packedLight, 1.0f, 0, 1, 1);
        CustomFishingHookerRender.vertex(vertexConsumer, pose, packedLight, 1.0f, 1, 1, 0);
        CustomFishingHookerRender.vertex(vertexConsumer, pose, packedLight, 0.0f, 1, 0, 0);
        matrixStack.popPose();
        int i = owner.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack itemStack = owner.getMainHandItem();
        if (!(itemStack.getItem() instanceof ItemToolFishingRod)) {
            i = -i;
        }
        float f = owner.getAttackAnim(partialTicks);
        float g = Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI));
        float yRot = Mth.lerp((float)partialTicks, (float)owner.yBodyRotO, (float)owner.yBodyRot) * ((float)Math.PI / 180);
        double d = Mth.sin((float)yRot);
        double e = Mth.cos((float)yRot);
        double j = (double)i * 0.35;
        if (this.entityRenderDispatcher.options != null && !this.entityRenderDispatcher.options.getCameraType().isFirstPerson() || owner != Minecraft.getInstance().player) {
            xPos = Mth.lerp((double)partialTicks, (double)owner.xo, (double)owner.getX()) - e * j - d * 0.8;
            yPos = owner.yo + (double)owner.getEyeHeight() + (owner.getY() - owner.yo) * (double)partialTicks - 0.45;
            zPos = Mth.lerp((double)partialTicks, (double)owner.zo, (double)owner.getZ()) - d * j + e * 0.8;
            o = owner.isCrouching() ? -0.1875f : 0.0f;
        } else {
            p = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f);
            vec3 = vec3.scale(p);
            vec3 = vec3.yRot(g * 0.5f);
            vec3 = vec3.xRot(-g * 0.7f);
            xPos = Mth.lerp((double)partialTicks, (double)owner.xo, (double)owner.getX()) + vec3.x;
            yPos = Mth.lerp((double)partialTicks, (double)owner.yo, (double)owner.getY()) + vec3.y;
            zPos = Mth.lerp((double)partialTicks, (double)owner.zo, (double)owner.getZ()) + vec3.z;
            o = owner.getEyeHeight();
        }
        p = Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX());
        double q = Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY()) + 0.25;
        double r = Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ());
        float s = (float)(xPos - p);
        float t = (float)(yPos - q) + o;
        float u = (float)(zPos - r);
        VertexConsumer vertexConsumer2 = buffer.getBuffer(RenderType.lineStrip());
        PoseStack.Pose pose2 = matrixStack.last();
        for (int w = 0; w <= 16; ++w) {
            CustomFishingHookerRender.stringVertex(s, t, u, vertexConsumer2, pose2, (float)w / 16.0f, (float)(w + 1) / 16.0f);
        }
        matrixStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, int light, float f, int j, int k, int l) {
        vertexConsumer.addVertex(pose, f - 0.5f, (float)j - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)k, (float)l).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float f, float g, float h, VertexConsumer vertexConsumer, PoseStack.Pose pose, float i, float j) {
        float k = f * i;
        float l = g * (i * i + i) * 0.5f + 0.25f;
        float m = h * i;
        float n = f * j - k;
        float o = g * (j * j + j) * 0.5f + 0.25f - l;
        float p = h * j - m;
        float q = Mth.sqrt((float)(n * n + o * o + p * p));
        vertexConsumer.addVertex(pose.pose(), k, l, m).setColor(0, 0, 0, 255).setNormal(pose, n / q, o / q, p / q);
    }

    public ResourceLocation getTextureLocation(CustomFishingHookEntity entity) {
        return TEXTURE_LOCATION;
    }
}

