/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.misc.DarknessEntity;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class DarknessRender
extends EntityRenderer<DarknessEntity> {
    private static final ResourceLocation TEX = RuneCraftory.modRes("textures/entity/projectile/darkness.png");
    protected final RenderUtils.TextureBuilder textureBuilder = new RenderUtils.TextureBuilder();

    public DarknessRender(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(DarknessEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        boolean playerView;
        float size = 1.5f + entity.getRadius() + Mth.sin((float)(((float)entity.tickCount + partialTicks) * 0.3f)) * 0.06f;
        this.textureBuilder.setLight(packedLight);
        stack.pushPose();
        boolean bl = playerView = entity.getOwner() == Minecraft.getInstance().player && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON;
        if (playerView) {
            stack.translate(0.0, 0.01, 0.0);
            stack.mulPose(Axis.YP.rotationDegrees(-(entity.getOwner().yRotO + (entity.getOwner().getYRot() - entity.getOwner().yRotO) * partialTicks) - 180.0f));
            stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity))), (float)size, (float)size, (RenderUtils.TextureBuilder)this.textureBuilder);
        } else {
            stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            stack.mulPose(Axis.YP.rotationDegrees(180.0f));
            RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity))), (float)size, (float)size, (RenderUtils.TextureBuilder)this.textureBuilder);
        }
        stack.popPose();
        super.render((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(DarknessEntity entity) {
        return TEX;
    }
}

