/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.common.entities.misc.ElementalTrailEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.client.render.TextureRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ElementalTrailRender
extends TextureRenderer<ElementalTrailEntity> {
    private static final ResourceLocation DARK = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/soul_fire_0");
    private static final ResourceLocation FIRE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/fire_0");
    private final BlockState ice = Blocks.ICE.defaultBlockState();
    private final BlockState dirt = Blocks.COARSE_DIRT.defaultBlockState();

    public ElementalTrailRender(EntityRendererProvider.Context ctx) {
        super(ctx, 1.0f, 1.0f, 1, 1);
    }

    public void render(ElementalTrailEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        switch (entity.element()) {
            case FIRE: 
            case DARK: {
                stack.translate(0.0, (double)this.ySize * 0.45, 0.0);
                stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                TextureAtlasSprite t = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(this.getTextureLocation(entity));
                this.textureBuilder.setUV(t.getU0(), t.getV0());
                this.textureBuilder.setUVLength(t.getU1() - t.getU0(), t.getV1() - t.getV0());
                RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(this.getRenderType((Entity)entity, t.atlasLocation())), (float)1.0f, (float)2.0f, (RenderUtils.TextureBuilder)this.textureBuilder);
                break;
            }
            case WATER: {
                this.renderBlockModel(this.ice, stack, buffer);
                break;
            }
            case EARTH: {
                this.renderBlockModel(this.dirt, stack, buffer);
            }
        }
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(ElementalTrailEntity entity) {
        return switch (entity.element()) {
            case ItemElement.FIRE -> FIRE;
            default -> DARK;
        };
    }

    private void renderBlockModel(BlockState state, PoseStack stack, MultiBufferSource buffer) {
        stack.translate(-0.5, -0.5, -0.5);
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        dispatcher.renderSingleBlock(state, stack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
    }
}

