/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.common.entities.misc.MobArrowEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MobArrowRender<T extends MobArrowEntity>
extends EntityRenderer<T> {
    public static final ResourceLocation ARROW = ResourceLocation.withDefaultNamespace((String)"textures/entity/projectiles/arrow.png");

    public MobArrowRender(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(T entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((MobArrowEntity)((Object)entity)).yRotO, (float)entity.getYRot()) - 90.0f));
        stack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((MobArrowEntity)((Object)entity)).xRotO, (float)entity.getXRot())));
        stack.mulPose(Axis.XP.rotationDegrees(45.0f));
        stack.scale(0.05625f, 0.05625f, 0.05625f);
        stack.translate(-4.0, 0.0, 0.0);
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
        PoseStack.Pose pose = stack.last();
        this.buildVertex(pose, consumer, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, packedLight);
        this.buildVertex(pose, consumer, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, packedLight);
        this.buildVertex(pose, consumer, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, packedLight);
        this.buildVertex(pose, consumer, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, packedLight);
        this.buildVertex(pose, consumer, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, packedLight);
        this.buildVertex(pose, consumer, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, packedLight);
        this.buildVertex(pose, consumer, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, packedLight);
        this.buildVertex(pose, consumer, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, packedLight);
        for (int j = 0; j < 4; ++j) {
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.buildVertex(pose, consumer, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, packedLight);
            this.buildVertex(pose, consumer, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, packedLight);
            this.buildVertex(pose, consumer, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, packedLight);
            this.buildVertex(pose, consumer, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, packedLight);
        }
        stack.popPose();
        super.render(entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ARROW;
    }

    public void buildVertex(PoseStack.Pose pose, VertexConsumer consumer, int x, int y, int z, float u, float v, int normalX, int normalZ, int normalY, int packedLight) {
        consumer.addVertex(pose, (float)x, (float)y, (float)z).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)normalX, (float)normalY, (float)normalZ);
    }
}

