/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.misc.PoisonNeedleEntity;
import io.github.flemmli97.tenshilib.client.render.CrossedTextureRenderer;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class PoisonNeedleRender
extends CrossedTextureRenderer<PoisonNeedleEntity> {
    private static final ResourceLocation TEX = RuneCraftory.modRes("textures/entity/projectile/poison_needle.png");

    public PoisonNeedleRender(EntityRendererProvider.Context ctx) {
        super(ctx, 0.8f, 0.8f, 1, 1);
    }

    public void render(PoisonNeedleEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        stack.translate(0.0, (double)this.ySize * 0.2, 0.0);
        super.render((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
        stack.popPose();
    }

    public void doRender(PoisonNeedleEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer) {
        stack.pushPose();
        stack.mulPose(Axis.XP.rotationDegrees(45.0f));
        for (int j = 0; j < 2; ++j) {
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            stack.pushPose();
            stack.translate(0.0, (double)(this.xSize * 1.0f / 16.0f) * 0.5, 0.0);
            RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(this.getRenderType((Entity)entity, this.getTextureLocation(entity))), (float)this.xSize, (float)this.ySize, (RenderUtils.TextureBuilder)this.textureBuilder);
            stack.popPose();
        }
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(PoisonNeedleEntity entity) {
        return TEX;
    }
}

