/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DashSlashAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.matches(state -> state.isPast("attack_start") && !state.isPast("attack_end")), 0).build();

    @Override
    public AnimationState getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.DASH_SLASH.get(comboIdx), speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, WeaponHandler<?> handler, AnimationState state) {
        if (handler.getComboCount() == 2) {
            handler.store(DataKey.MOVE_DIRECTION, null);
            handler.applyDelta(entity.getDeltaMovement().multiply(0.95, 1.0, 0.95));
            if (state.isAt("attack")) {
                if (!entity.level().isClientSide) {
                    OrientedBoundingBox obb = new OrientedBoundingBox(new AABB((double)(-entity.getBbWidth()), 0.0, 0.0, (double)entity.getBbWidth(), 1.0, (double)(entity.getBbWidth() + 1.0f)).inflate(0.3), entity.getYRot(), 0.0f, entity.position());
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(obb)).withBonusAttributesMultiplier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.DASH_SLASH)).doOnSuccess(e -> CombatUtils.knockBackEntity(entity, e, 1.0f)).executeAttack();
                }
                DashSlashAttack.playSound((Entity)entity, SoundEvents.PLAYER_ATTACK_STRONG, 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
        } else {
            Vec3 dir;
            handler.store(DataKey.FIXED_LOOK, true);
            if (state.isAt("move_start")) {
                dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                handler.store(DataKey.MOVE_DIRECTION, dir.scale(0.6).add(0.0, 0.3, 0.0));
            }
            if (state.isPast("attack_start")) {
                if (state.isAt("attack_start")) {
                    dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                    handler.store(DataKey.MOVE_DIRECTION, dir.scale(0.9));
                }
                if (state.isAt("sound")) {
                    DashSlashAttack.playSound((Entity)entity, (SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
                }
                if (!entity.level().isClientSide && !state.isPast("attack_end")) {
                    double range = CombatUtils.getRange(entity, -1.0);
                    handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.getBoundingBox().inflate(range * 0.5, 0.0, 0.0).expandTowards(0.0, 0.0, range))).withBonusAttributes((Holder<Attribute>)Attributes.ATTACK_DAMAGE, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.DASH_SLASH)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                }
            }
            if (state.isAt("attack_end")) {
                handler.applyDelta(entity.getDeltaMovement().multiply(0.8, 1.0, 0.8));
                handler.store(DataKey.MOVE_DIRECTION, null);
            }
        }
    }

    @Override
    public void onEnd(LivingEntity entity, WeaponHandler<?> handler) {
        if (handler.getComboCount() != 1) {
            return;
        }
        Vec3 mot = entity.getDeltaMovement();
        double lenHor = mot.x * mot.x + mot.z * mot.z;
        handler.applyDelta(mot.multiply(lenHor > 0.5 ? 0.5 : 1.0, 1.0, lenHor > 0.5 ? 0.5 : 1.0));
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, WeaponHandler<?> handler) {
        return handler.getComboCount() == 1;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

