/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class StardustUpperAttack
extends AttackAction {
    @Override
    public AnimationState getAnimation(LivingEntity entity, int comboIdx) {
        double speed = EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.STARDUST_UPPER, speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, WeaponHandler<?> handler, AnimationState state) {
        Vec3 dir;
        if (state.isAt("attack_start_1")) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.getYRot() - 110.0f));
            StardustUpperAttack.playSound((Entity)entity, (SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
            dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            handler.applyDelta(dir.scale(0.7));
        }
        if (state.isAt("attack_start_2")) {
            handler.resetHitEntityTracker();
            StardustUpperAttack.playSound((Entity)entity, (SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
            dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            handler.applyDelta(dir.scale(0.7));
        }
        if (!entity.level().isClientSide) {
            CombatUtils.EntityAttack attack2;
            CombatUtils.EntityAttack attack = StardustUpperAttack.spinAttack(entity, state, state.getMarker("attack_start_1", 0), state.getMarker("attack_end_1", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 410.0f, 0.0f);
            if (attack != null) {
                handler.addHitEntityTracker(attack.withBonusAttributesMultiplier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.STARDUST_UPPER)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
            if ((attack2 = StardustUpperAttack.spinAttack(entity, state, state.getMarker("attack_start_2", 0), state.getMarker("attack_end_2", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 410.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() + 680.0f, p -> Mth.sin((float)(p * (float)Math.PI)) * 50.0f, 0.0f)) != null) {
                handler.addHitEntityTracker(attack2.withBonusAttributesMultiplier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.STARDUST_UPPER)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).doOnSuccess(target -> {
                    CombatUtils.knockBackEntity(entity, target, 0.4f);
                    target.setDeltaMovement(target.getDeltaMovement().add(0.0, 0.3, 0.0));
                }).executeAttack());
            }
        }
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

