/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class UpperCutAttack
extends AttackAction {
    @Override
    public AnimationState getAnimation(LivingEntity entity, int comboIdx) {
        double speed = EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.UPPER_CUT, speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, WeaponHandler<?> handler, AnimationState state) {
        if (state.isAt("attack")) {
            UpperCutAttack.playSound((Entity)entity, (SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
            if (!entity.level().isClientSide) {
                AABB aabb = new AABB(-1.0, -0.02, 0.0, 1.0, (double)(entity.getBbHeight() + 1.0f), (double)(entity.getBbWidth() + 2.0f));
                OrientedBoundingBox obb = new OrientedBoundingBox(aabb, entity.getYRot(), 0.0f, entity.position());
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(obb)).withBonusAttributesMultiplier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.UPPER_CUT)).doOnSuccess(e -> e.setDeltaMovement(e.getDeltaMovement().add(0.0, 0.8, 0.0))).executeAttack();
            }
        }
    }
}

