/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.blocks.CraftingBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.BrokenMineralBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.util.MineralBlockTier;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.platform.ExtendedBlock;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.github.flemmli97.tenshilib.common.utils.VoxelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrokenMineralBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock,
ExtendedBlock {
    public static final MapCodec<BrokenMineralBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)CodecUtils.stringEnumCodec(MineralBlockTier.class, null).fieldOf("mineral_tier").forGetter(d -> d.tier), (App)BrokenMineralBlock.propertiesCodec()).apply((Applicative)inst, BrokenMineralBlock::new));
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape[] SHAPES = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)8.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)5.0), VoxelUtils.ShapeBuilder.of((double)10.0, (double)0.0, (double)8.0, (double)13.0, (double)1.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)9.0, (double)0.0, (double)10.0, (double)16.0, (double)1.0, (double)15.0), VoxelUtils.ShapeBuilder.of((double)6.0, (double)0.0, (double)8.0, (double)10.0, (double)3.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)3.0, (double)0.0, (double)10.0, (double)9.0, (double)2.0, (double)14.0), VoxelUtils.ShapeBuilder.of((double)6.0, (double)0.0, (double)3.0, (double)8.0, (double)1.0, (double)4.0), VoxelUtils.ShapeBuilder.of((double)2.0, (double)0.0, (double)1.0, (double)7.0, (double)1.0, (double)3.0), VoxelUtils.ShapeBuilder.of((double)1.0, (double)0.0, (double)3.0, (double)6.0, (double)3.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)10.0, (double)3.0, (double)1.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)6.0, (double)0.0, (double)4.0, (double)13.0, (double)2.0, (double)8.0), VoxelUtils.ShapeBuilder.of((double)10.0, (double)0.3, (double)9.0, (double)12.0, (double)1.3, (double)10.0), VoxelUtils.ShapeBuilder.of((double)6.75, (double)1.55, (double)4.5, (double)8.75, (double)2.55, (double)7.5), VoxelUtils.ShapeBuilder.of((double)3.75, (double)1.55, (double)9.5, (double)5.75, (double)2.55, (double)11.5)});
    public final MineralBlockTier tier;

    public BrokenMineralBlock(MineralBlockTier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<BrokenMineralBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(ctx.getPlayer() != null ? ctx.getPlayer().getDirection().getOpposite() : Direction.NORTH))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            level.levelEvent(null, 2001, pos, Block.getId((BlockState)state));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, state.getFluidState().getType(), Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos, Direction.UP, SupportType.FULL);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue((Property)CraftingBlock.FACING)).get2DDataValue()];
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level.isClientSide) {
            return false;
        }
        if (player.isCreative() || player.isShiftKeyDown()) {
            this.playerWillDestroy(level, pos, state, player);
            return level.setBlock(pos, fluid.createLegacyBlock(), 3);
        }
        return false;
    }

    public BlockState getMineralState(BlockState state) {
        BlockState blockState = ((Block)RuneCraftoryBlocks.MINERAL_MAP.get((Object)this.tier).get()).defaultBlockState();
        if (state.hasProperty((Property)FACING)) {
            state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        }
        if (state.hasProperty((Property)WATERLOGGED)) {
            state.setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
        }
        return blockState;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BrokenMineralBlockEntity(pos, state);
    }
}

