/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.blocks.HerbBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.Growable;
import io.github.flemmli97.runecraftory.common.blocks.util.GrowableCrop;
import io.github.flemmli97.runecraftory.common.blocks.util.LazyResolvedRegistryEntry;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExtendedCropBlock
extends CropBlock
implements GrowableCrop,
Growable {
    public static final MapCodec<ExtendedCropBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ExtendedCropBlock.propertiesCodec(), (App)LazyResolvedRegistryEntry.codec(Registries.ITEM).fieldOf("crop").forGetter(d -> d.crop), (App)LazyResolvedRegistryEntry.codec(Registries.ITEM).fieldOf("seed").forGetter(d -> d.seed)).apply((Applicative)inst, ExtendedCropBlock::new));
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)4);
    public static final BooleanProperty WILTED = BooleanProperty.create((String)"wilted");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)};
    protected final LazyResolvedRegistryEntry<Item> crop;
    protected final LazyResolvedRegistryEntry<Item> seed;

    public ExtendedCropBlock(BlockBehaviour.Properties prop, ResourceKey<Item> crop, ResourceKey<Item> seed) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)WILTED, (Comparable)Boolean.valueOf(false)));
        this.crop = new LazyResolvedRegistryEntry<Item>(crop);
        this.seed = new LazyResolvedRegistryEntry<Item>(seed);
    }

    private ExtendedCropBlock(BlockBehaviour.Properties prop, LazyResolvedRegistryEntry<Item> crop, LazyResolvedRegistryEntry<Item> seed) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)WILTED, (Comparable)Boolean.valueOf(false)));
        this.crop = crop;
        this.seed = seed;
    }

    public MapCodec<? extends ExtendedCropBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)AGE)];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return false;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
    }

    protected ItemLike getBaseSeedId() {
        return Items.AIR;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack(this.seed.get((HolderLookup.Provider)level.registryAccess()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE}).add(new Property[]{WILTED});
    }

    public Item getCrop(HolderLookup.Provider provider) {
        return (Item)this.crop.get(provider).value();
    }

    public Item getCrop(HolderLookup<Item> provider) {
        return (Item)this.crop.get(provider).value();
    }

    @Override
    public void onWither(int amount, Level level, BlockState state, BlockPos pos) {
        if (amount > 1 || ((Boolean)state.getValue((Property)WILTED)).booleanValue()) {
            level.setBlock(pos, ((HerbBlock)((Object)RuneCraftoryBlocks.WITHERED_GRASS.get())).defaultBlockState(), 3);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)WILTED, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    @Override
    public void onWater(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)WILTED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)WILTED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public int getGiantAge() {
        return 4;
    }

    @Override
    public int runecraftory$getGrowableMaxAge() {
        return this.getMaxAge();
    }

    @Override
    public BlockState runecraftory$getGrowableStateForAge(BlockState current, int age) {
        return this.getStateForAge(age);
    }

    @Override
    public boolean runecraftory$isAtMaxAge(BlockState state) {
        return this.isMaxAge(state);
    }
}

