/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.blocks.ExtendedCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.LazyResolvedRegistryEntry;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.utils.VoxelUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GiantCropBlock
extends ExtendedCropBlock {
    public static final MapCodec<GiantCropBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)GiantCropBlock.propertiesCodec(), (App)LazyResolvedRegistryEntry.codec(Registries.ITEM).fieldOf("crop").forGetter(d -> d.crop), (App)LazyResolvedRegistryEntry.codec(Registries.ITEM).fieldOf("seed").forGetter(d -> d.seed), (App)Codec.BOOL.fieldOf("small").forGetter(d -> d.small)).apply((Applicative)inst, GiantCropBlock::new));
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    protected static final List<Pair<BlockPos, Direction>> CROP_POSITION = List.of(Pair.of((Object)new BlockPos(0, 0, 0), (Object)Direction.NORTH), Pair.of((Object)new BlockPos(0, 1, 0), (Object)Direction.NORTH), Pair.of((Object)new BlockPos(0, 0, -1), (Object)Direction.WEST), Pair.of((Object)new BlockPos(0, 1, -1), (Object)Direction.WEST), Pair.of((Object)new BlockPos(-1, 0, 0), (Object)Direction.EAST), Pair.of((Object)new BlockPos(-1, 1, 0), (Object)Direction.EAST), Pair.of((Object)new BlockPos(-1, 0, -1), (Object)Direction.SOUTH), Pair.of((Object)new BlockPos(-1, 1, -1), (Object)Direction.SOUTH));
    private static final VoxelShape[] SHAPE_BOTTOM = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0)});
    private static final VoxelShape[] SHAPE_TOP = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0)});
    private static final VoxelShape[] SHAPE_TOP_LESS = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)5.0, (double)12.0)});
    private final boolean small;

    public GiantCropBlock(BlockBehaviour.Properties prop, ResourceKey<Item> giant, ResourceKey<Item> seed) {
        this(prop, giant, seed, false);
    }

    public GiantCropBlock(BlockBehaviour.Properties prop, ResourceKey<Item> giant, ResourceKey<Item> seed, boolean small) {
        super(prop, giant, seed);
        this.small = small;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(DIRECTION, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM));
    }

    private GiantCropBlock(BlockBehaviour.Properties prop, LazyResolvedRegistryEntry<Item> crop, LazyResolvedRegistryEntry<Item> seed, boolean small) {
        this(prop, crop.getKey(), seed.getKey(), small);
    }

    public MapCodec<GiantCropBlock> codec() {
        return CODEC;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == Half.TOP) {
            if (this.small) {
                return SHAPE_TOP_LESS[((Direction)state.getValue(DIRECTION)).get2DDataValue()];
            }
            return SHAPE_TOP[((Direction)state.getValue(DIRECTION)).get2DDataValue()];
        }
        return SHAPE_BOTTOM[((Direction)state.getValue(DIRECTION)).get2DDataValue()];
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    @Override
    public int getMaxAge() {
        return 1;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is((Block)this) && state.getValue(HALF) == Half.BOTTOM || super.mayPlaceOn(state, level, pos);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        Half half;
        Direction fromHalf;
        Direction dir = (Direction)state.getValue(DIRECTION);
        if (direction == dir) {
            if (!neighborState.is((Block)this) || ((Direction)neighborState.getValue(DIRECTION)).getClockWise() != dir) {
                return Blocks.AIR.defaultBlockState();
            }
            int neightborAge = (Integer)neighborState.getValue((Property)AGE);
            if (neightborAge != (Integer)state.getValue((Property)AGE)) {
                return (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(neightborAge));
            }
        }
        Direction direction2 = fromHalf = (half = (Half)state.getValue(HALF)) == Half.BOTTOM ? Direction.UP : Direction.DOWN;
        if (fromHalf == direction) {
            if (!neighborState.is((Block)this) || neighborState.getValue(HALF) != (half == Half.BOTTOM ? Half.TOP : Half.BOTTOM)) {
                return Blocks.AIR.defaultBlockState();
            }
            int neightborAge = (Integer)neighborState.getValue((Property)AGE);
            if (neightborAge != (Integer)state.getValue((Property)AGE)) {
                return (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(neightborAge));
            }
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && player.isCreative() && (state.getValue(DIRECTION) != Direction.NORTH || state.getValue(HALF) != Half.BOTTOM)) {
            ArrayList<Pair> positions = new ArrayList<Pair>();
            AtomicReference first = new AtomicReference();
            this.applyToCrop(level, pos, state, (p, s) -> {
                if (!p.equals((Object)pos)) {
                    if (s.getValue(DIRECTION) == Direction.NORTH && s.getValue(HALF) == Half.BOTTOM) {
                        first.set(Pair.of((Object)p, (Object)s));
                    } else {
                        positions.add(Pair.of((Object)p, (Object)s));
                    }
                }
            });
            if (first.get() != null) {
                positions.addFirst((Pair)first.get());
            }
            positions.forEach(p -> {
                level.setBlock((BlockPos)p.getFirst(), Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent(player, 2001, (BlockPos)p.getFirst(), Block.getId((BlockState)((BlockState)p.getSecond())));
            });
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE}).add(new Property[]{ExtendedCropBlock.WILTED}).add(new Property[]{DIRECTION}).add(new Property[]{HALF});
    }

    @Override
    public int getGiantAge() {
        return 0;
    }

    @Override
    public BlockState runecraftory$getGrowableStateForAge(BlockState current, int age) {
        return (BlockState)current.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    @Override
    public void onWither(int amount, Level level, BlockState state, BlockPos pos) {
        this.applyToCrop(level, pos, state, (p, s) -> super.onWither(amount, level, (BlockState)s, (BlockPos)p));
    }

    @Override
    public void onWater(Level level, BlockPos pos, BlockState state) {
        this.applyToCrop(level, pos, state, (p, s) -> {
            super.onWater(level, (BlockPos)p, (BlockState)s);
            BlockPos belowPos = p.below();
            BlockState below = level.getBlockState(belowPos);
            if (below.hasProperty((Property)FarmBlock.MOISTURE)) {
                level.setBlock(belowPos, (BlockState)below.setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)), 3);
            }
        });
    }

    @Override
    public boolean canGrow(ServerLevel level, BlockPos pos, BlockState state) {
        return state.getValue(HALF) == Half.BOTTOM && state.getValue(DIRECTION) == Direction.NORTH && !this.runecraftory$isAtMaxAge(state);
    }

    @Override
    public BlockPos getCropPosition(Level level, BlockPos pos, BlockState state) {
        BlockState target;
        BlockPos.MutableBlockPos newPos = pos.mutable();
        for (Direction dir = (Direction)state.getValue(DIRECTION); dir != Direction.NORTH; dir = dir.getCounterClockWise()) {
            newPos.move(dir);
        }
        if (state.getValue(HALF) == Half.TOP) {
            newPos.move(0, -1, 0);
        }
        if (!(target = level.getBlockState((BlockPos)newPos)).is((Block)this)) {
            return pos;
        }
        return newPos.immutable();
    }

    private void applyToCrop(Level level, BlockPos start, BlockState current, BiConsumer<BlockPos, BlockState> apply) {
        BlockPos.MutableBlockPos mut = start.mutable();
        Direction dir = (Direction)current.getValue(DIRECTION);
        Half half = (Half)current.getValue(HALF);
        if (half == Half.TOP) {
            start = start.below();
        }
        Rotation rot = EntityUtils.fromDirection(dir);
        for (Pair<BlockPos, Direction> pos : CROP_POSITION) {
            Direction blockDir;
            BlockPos rotated = ((BlockPos)pos.getFirst()).rotate(rot);
            mut.setWithOffset((Vec3i)start, (Vec3i)rotated);
            BlockState blockAt = level.getBlockState((BlockPos)mut);
            if (!blockAt.is((Block)this) || (blockDir = (Direction)blockAt.getValue(DIRECTION)) != rot.rotate((Direction)pos.getSecond()) || blockAt.getValue(HALF) != (((BlockPos)pos.getFirst()).getY() == 1 ? Half.TOP : Half.BOTTOM)) continue;
            apply.accept(mut.immutable(), blockAt);
        }
    }

    public boolean isGiantOf(BlockState current, BlockState newState) {
        if (current.is(newState.getBlock())) {
            return false;
        }
        CropProperties prop = DataPackHandler.INSTANCE.cropManager().get(current.getBlock());
        return prop != null && prop.getGiantVersion().map(b -> b == this).orElse(false) != false;
    }
}

