/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.blocks.CraftingBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.MineralBlockTier;
import io.github.flemmli97.runecraftory.common.items.ToolItemTier;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHammer;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.platform.ExtendedBlock;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.github.flemmli97.tenshilib.common.utils.VoxelUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MineralBlock
extends Block
implements SimpleWaterloggedBlock,
ExtendedBlock {
    public static final MapCodec<MineralBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)CodecUtils.stringEnumCodec(MineralBlockTier.class, null).fieldOf("mineral_tier").forGetter(d -> d.tier), (App)MineralBlock.propertiesCodec()).apply((Applicative)inst, MineralBlock::new));
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape[] SHAPES = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)8.0, (double)0.0, (double)0.0, (double)13.0, (double)6.0, (double)5.0), VoxelUtils.ShapeBuilder.of((double)10.0, (double)0.0, (double)8.0, (double)13.0, (double)11.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)9.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0, (double)15.0), VoxelUtils.ShapeBuilder.of((double)6.0, (double)0.0, (double)8.0, (double)10.0, (double)8.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)3.0, (double)0.0, (double)10.0, (double)9.0, (double)5.0, (double)14.0), VoxelUtils.ShapeBuilder.of((double)6.0, (double)0.0, (double)3.0, (double)8.0, (double)4.0, (double)4.0), VoxelUtils.ShapeBuilder.of((double)2.0, (double)0.0, (double)1.0, (double)7.0, (double)2.0, (double)3.0), VoxelUtils.ShapeBuilder.of((double)1.0, (double)0.0, (double)3.0, (double)6.0, (double)11.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)10.0, (double)3.0, (double)2.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)6.0, (double)0.0, (double)4.0, (double)13.0, (double)15.0, (double)8.0), VoxelUtils.ShapeBuilder.of((double)4.0, (double)5.0, (double)10.0, (double)7.0, (double)6.0, (double)11.0), VoxelUtils.ShapeBuilder.of((double)11.0, (double)5.5, (double)10.3, (double)12.0, (double)6.5, (double)12.3), VoxelUtils.ShapeBuilder.of((double)12.8, (double)4.8, (double)5.3, (double)14.8, (double)5.8, (double)9.3), VoxelUtils.ShapeBuilder.of((double)1.4, (double)1.3, (double)9.6, (double)4.4, (double)2.3, (double)11.6), VoxelUtils.ShapeBuilder.of((double)7.1, (double)4.5, (double)12.8, (double)10.1, (double)5.5, (double)13.8), VoxelUtils.ShapeBuilder.of((double)3.6, (double)10.4, (double)7.0, (double)5.6, (double)11.4, (double)9.0), VoxelUtils.ShapeBuilder.of((double)3.6, (double)6.4, (double)2.5, (double)5.6, (double)7.4, (double)3.5), VoxelUtils.ShapeBuilder.of((double)6.6, (double)2.4, (double)2.5, (double)8.6, (double)3.4, (double)3.5), VoxelUtils.ShapeBuilder.of((double)10.6, (double)11.4, (double)7.5, (double)11.6, (double)12.4, (double)8.5), VoxelUtils.ShapeBuilder.of((double)8.6, (double)8.4, (double)3.5, (double)11.6, (double)10.4, (double)4.5), VoxelUtils.ShapeBuilder.of((double)0.6, (double)5.0, (double)4.2, (double)1.6, (double)7.0, (double)8.2)});
    public final MineralBlockTier tier;

    public MineralBlock(MineralBlockTier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<MineralBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(ctx.getPlayer() != null ? ctx.getPlayer().getDirection().getOpposite() : Direction.NORTH))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            level.levelEvent(null, 2001, pos, Block.getId((BlockState)state));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Entity entity = (Entity)builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            float addChance = (float)data.getSkillLevel(Skills.MINING).getLevel() * 0.03f;
            ItemStack stack = player.getMainHandItem();
            if (stack.getItem() instanceof ItemToolHammer && stack.has((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get())) {
                addChance = (float)((double)addChance + (double)((ToolItemTier)((Object)stack.get((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get()))).getTierLevel() * 0.75);
            }
            builder.withLuck(addChance + EntityUtils.playerLuck(player));
        }
        return super.getDrops(state, builder);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos, Direction.UP, SupportType.FULL);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue((Property)CraftingBlock.FACING)).get2DDataValue()];
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float f = super.getDestroyProgress(state, player, level, pos);
        return player.getMainHandItem().is(RunecraftoryTags.Items.HAMMER_TOOLS) ? f : f * 0.5f;
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.isCreative()) {
            this.playerWillDestroy(level, pos, state, player);
            return level.setBlock(pos, fluid.createLegacyBlock(), 3);
        }
        if (player.hasCorrectToolForDrops(state)) {
            pos = pos.immutable();
            float breakChance = 0.7f;
            ItemStack stack = player.getMainHandItem();
            if (stack.getItem() instanceof ItemToolHammer && stack.has((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get())) {
                breakChance -= (float)(((ToolItemTier)((Object)stack.get((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get()))).getTierLevel() + 1) * 0.05f;
            }
            this.playerWillDestroy(level, pos, state, player);
            if (level.random.nextFloat() < breakChance) {
                return level.setBlock(pos, this.getBrokenState(state), 3);
            }
            MineralBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            serverPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket(pos, state));
            return false;
        }
        return false;
    }

    public BlockState getBrokenState(BlockState state) {
        BlockState blockState = ((Block)RuneCraftoryBlocks.BROKEN_MINERAL_MAP.get((Object)this.tier).get()).defaultBlockState();
        if (blockState.hasProperty((Property)FACING)) {
            blockState.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        }
        if (blockState.hasProperty((Property)WATERLOGGED)) {
            blockState.setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
        }
        return blockState;
    }
}

