/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.blocks.entity.MonsterBarnBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MonsterBarnBlock
extends BaseEntityBlock {
    public static final MapCodec<MonsterBarnBlock> CODEC = MonsterBarnBlock.simpleCodec(MonsterBarnBlock::new);
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public MonsterBarnBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<MonsterBarnBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)placer;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MonsterBarnBlockEntity) {
                MonsterBarnBlockEntity barn = (MonsterBarnBlockEntity)blockEntity;
                barn.setOwner(player.getUUID());
            }
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        PlayerData data;
        UUID owner;
        block5: {
            block4: {
                owner = null;
                if (player.isCreative()) break block4;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof MonsterBarnBlockEntity)) break block5;
                MonsterBarnBlockEntity barn = (MonsterBarnBlockEntity)blockEntity;
                owner = barn.getOwner();
                if (!player.getUUID().equals(owner)) break block5;
            }
            return super.getDestroyProgress(state, player, level, pos);
        }
        if (!player.level().isClientSide && owner != null && (data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).onBarnFailMine(pos)) {
            player.displayClientMessage((Component)Component.translatable((String)"runecraftory.barn.interact.not.owner", (Object[])new Object[]{player.getServer().getProfileCache().get(owner).map(GameProfile::getName).orElse("UNKNOWN")}).withStyle(ChatFormatting.DARK_RED), false);
        }
        return 0.0f;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MonsterBarnBlockEntity) {
            MonsterBarnBlockEntity barn = (MonsterBarnBlockEntity)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                RunecraftorySavedData.get(serverLevel.getServer()).removeBarn(barn.getOwner(), GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos));
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        UUID owner;
        block2: {
            MonsterBarnBlockEntity barn;
            block3: {
                if (level.isClientSide) return ItemInteractionResult.SUCCESS;
                owner = null;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof MonsterBarnBlockEntity)) break block2;
                barn = (MonsterBarnBlockEntity)blockEntity;
                if (player.isCreative()) break block3;
                owner = barn.getOwner();
                if (!player.getUUID().equals(owner)) break block2;
            }
            if (barn.getBarnData() == null) return ItemInteractionResult.CONSUME;
            String key = barn.getBarnData().hasRoof() ? "runecraftory.barn.interact.block.roofed" : "runecraftory.barn.interact.block";
            player.displayClientMessage((Component)Component.translatable((String)key, (Object[])new Object[]{barn.getBarnData().getCapacity(), barn.getBarnData().getCapacity() - barn.getBarnData().usedCapacity()}).withStyle(barn.getBarnData().getCapacity() > 0 ? ChatFormatting.GOLD : ChatFormatting.DARK_RED), true);
            return ItemInteractionResult.CONSUME;
        }
        if (owner == null) return ItemInteractionResult.CONSUME;
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        if (!data.onBarnFailMine(pos)) return ItemInteractionResult.CONSUME;
        player.displayClientMessage((Component)Component.translatable((String)"runecraftory.barn.interact.not.owner", (Object[])new Object[]{player.getServer().getProfileCache().get(owner).map(GameProfile::getName).orElse("UNKNOWN")}).withStyle(ChatFormatting.DARK_RED), false);
        return ItemInteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MonsterBarnBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RuneCraftoryBlocks.MONSTER_BARN_BLOCK_ENTITY.get()), MonsterBarnBlockEntity::tick);
    }
}

