/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.utils.VoxelUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class QuestboardBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<QuestboardBlock> CODEC = QuestboardBlock.simpleCodec(QuestboardBlock::new);
    public static final VoxelShape[] BOTTOM_LEFT = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)7.0, (double)2.0, (double)10.0, (double)9.0), VoxelUtils.ShapeBuilder.of((double)1.0, (double)11.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5), VoxelUtils.ShapeBuilder.of((double)0.0, (double)10.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)1.0, (double)10.0, (double)6.0, (double)16.0, (double)11.0, (double)10.0)});
    public static final VoxelShape[] BOTTOM_RIGHT = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)14.0, (double)0.0, (double)7.0, (double)16.0, (double)10.0, (double)9.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)11.0, (double)6.5, (double)15.0, (double)16.0, (double)9.5), VoxelUtils.ShapeBuilder.of((double)15.0, (double)10.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)10.0, (double)6.0, (double)15.0, (double)11.0, (double)10.0)});
    public static final VoxelShape[] TOP_LEFT = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)1.0, (double)0.0, (double)6.5, (double)16.0, (double)15.0, (double)9.5), VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)1.0, (double)15.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0)});
    public static final VoxelShape[] TOP_RIGHT = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)6.5, (double)15.0, (double)15.0, (double)9.5), VoxelUtils.ShapeBuilder.of((double)15.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)15.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0)});
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final double RANGE = 48.0;

    public QuestboardBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<QuestboardBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (((Part)((Object)state.getValue(PART))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BOTTOM_LEFT[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
            case 1 -> BOTTOM_RIGHT[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
            case 2 -> TOP_LEFT[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
            case 3 -> TOP_RIGHT[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
        };
    }

    public BlockState updateShape(BlockState state, Direction fromDir, BlockState fromState, LevelAccessor level, BlockPos pos, BlockPos fromPos) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        Part part = (Part)((Object)state.getValue(PART));
        Direction normalizedFrom = QuestboardBlock.rotateBy(fromDir, dir);
        if (part.neighbors.contains(normalizedFrom) && (!fromState.is((Block)this) || fromState.getValue((Property)FACING) != dir || fromState.getValue(PART) != Part.getPartFor(part, normalizedFrom))) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, fromDir, fromState, level, pos, fromPos);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!(player instanceof ServerPlayer)) {
            return ItemInteractionResult.CONSUME;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        QuestHandler.openGui(serverPlayer, Vec3.atCenterOf((Vec3i)pos));
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state;
        BlockPos blockpos = ctx.getClickedPos();
        if (ctx.getLevel().getBlockState(blockpos).canBeReplaced(ctx) && QuestboardBlock.getPosMap(blockpos, state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).stream().allMatch(p -> ctx.getLevel().getBlockState((BlockPos)p.getSecond()).canBeReplaced(ctx))) {
            return state;
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity living, ItemStack stack) {
        super.setPlacedBy(level, pos, state, living, stack);
        if (!level.isClientSide) {
            QuestboardBlock.getPosMap(pos, state).forEach(p -> level.setBlock((BlockPos)p.getSecond(), (BlockState)state.setValue(PART, (Comparable)((Object)((Part)((Object)((Object)p.getFirst()))))), 3));
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && player.isCreative()) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            QuestboardBlock.getPosMap(pos, state).forEach(p -> {
                BlockState other = level.getBlockState((BlockPos)p.getSecond());
                if (other.is((Block)this) && other.getValue((Property)FACING) == facing && other.getValue(PART) == p.getFirst()) {
                    level.setBlock((BlockPos)p.getSecond(), Blocks.AIR.defaultBlockState(), 3);
                    level.levelEvent(player, 2001, (BlockPos)p.getSecond(), Block.getId((BlockState)other));
                }
            });
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    public static List<Pair<Part, BlockPos>> getPosMap(BlockPos from, BlockState state) {
        Rotation rotation = EntityUtils.fromDirection((Direction)state.getValue((Property)FACING));
        BlockPos offset = ((Part)((Object)state.getValue(QuestboardBlock.PART))).offset;
        return Arrays.stream(Part.values()).map(p -> Pair.of((Object)p, (Object)p.offset.offset(-offset.getX(), -offset.getY(), -offset.getZ()).rotate(rotation).offset((Vec3i)from))).toList();
    }

    private static Direction rotateBy(Direction direction, Direction rotate) {
        if (direction.getAxis() == Direction.Axis.Y) {
            return direction;
        }
        return switch (rotate) {
            case Direction.SOUTH -> direction.getOpposite();
            case Direction.EAST -> direction.getCounterClockWise();
            case Direction.WEST -> direction.getClockWise();
            default -> direction;
        };
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM_LEFT(BlockPos.ZERO, List.of(Direction.UP, Direction.EAST)),
        BOTTOM_RIGHT(new BlockPos(1, 0, 0), List.of(Direction.UP, Direction.WEST)),
        TOP_LEFT(new BlockPos(0, 1, 0), List.of(Direction.DOWN, Direction.EAST)),
        TOP_RIGHT(new BlockPos(1, 1, 0), List.of(Direction.DOWN, Direction.WEST));

        public final BlockPos offset;
        public final List<Direction> neighbors;

        private Part(BlockPos offset, List<Direction> neighbors) {
            this.offset = offset;
            this.neighbors = neighbors;
        }

        @Nullable
        public static Part getPartFor(Part part, Direction direction) {
            BlockPos otherPos = part.offset.offset(direction.getNormal());
            for (Part p : Part.values()) {
                if (!p.offset.equals((Object)otherPos)) continue;
                return p;
            }
            return null;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

