/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.entity;

import io.github.flemmli97.runecraftory.common.blocks.BrokenMineralBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.DailyUpdateable;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BrokenMineralBlockEntity
extends BlockEntity
implements DailyUpdateable {
    private int lastUpdateDay;
    private boolean check;

    public BrokenMineralBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RuneCraftoryBlocks.BROKEN_MINERAL_TILE.get(), blockPos, blockState);
    }

    @Override
    public void update(ServerLevel level) {
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof BrokenMineralBlock) {
            BrokenMineralBlock mineral = (BrokenMineralBlock)block;
            this.level.setBlockAndUpdate(this.worldPosition, mineral.getMineralState(state));
        }
    }

    @Override
    public boolean inValid() {
        return this.isRemoved();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        Level level2 = this.level;
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            RunecraftorySavedData.get(serverLevel.getServer()).addToTracker(this);
            int day = WorldUtils.day(this.level);
            if (this.check && this.lastUpdateDay != day) {
                this.level.getServer().tell((Runnable)new TickTask(1, () -> this.update(serverLevel)));
            } else {
                this.lastUpdateDay = day;
                this.check = false;
                this.level.getServer().tell((Runnable)new TickTask(1, () -> ((BrokenMineralBlockEntity)this).setChanged()));
            }
        }
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.lastUpdateDay = nbt.getInt("LastUpdate");
        this.check = true;
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.putInt("LastUpdate", this.lastUpdateDay);
    }

    public void setRemoved() {
        super.setRemoved();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RunecraftorySavedData.get(serverLevel.getServer()).removeFromTracker(this);
        }
    }
}

