/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.entity;

import io.github.flemmli97.runecraftory.common.inventory.SimpleItemContainer;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CraftingBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final String DISPLAY_PREFIX = "runecraftory.container.crafting.";
    private final SimpleItemContainer container;
    private final CraftingType type;
    private int craftingIndex;

    public CraftingBlockEntity(BlockEntityType<?> blockEntityType, CraftingType type, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.type = type;
        this.container = new SimpleItemContainer(this, 6);
    }

    public Container getContainer() {
        return this.container;
    }

    public Component getDisplayName() {
        return Component.translatable((String)(DISPLAY_PREFIX + this.type.getId()));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.container.load(tag.getCompound("Inventory"), provider);
        this.craftingIndex = tag.getInt("Index");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Inventory", (Tag)this.container.save(provider));
        tag.putInt("Index", this.craftingIndex);
    }

    public void dropContents(Level level, BlockPos pos) {
        Containers.dropContents((Level)level, (BlockPos)pos, (Container)this.getContainer());
    }

    public AbstractContainerMenu createMenu(int windowID, Inventory inventory, Player player) {
        return new ContainerCrafting(windowID, inventory, this);
    }

    public int craftingIndex() {
        return this.craftingIndex;
    }

    public void setIndex(int craftingIndex) {
        this.craftingIndex = craftingIndex;
    }

    public void resetIndex() {
        this.craftingIndex = 0;
    }

    public CraftingType craftingType() {
        return this.type;
    }
}

