/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.entity;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.client.ClientFarmlandHandler;
import io.github.flemmli97.runecraftory.common.blocks.TreeFruitLeavesBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeLeavesBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeLogBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandDataContainer;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeBlockEntity
extends BlockEntity {
    private final PositionHolder logs = new PositionHolder();
    private final PositionHolder leaves = new PositionHolder();
    private final PositionHolder fruits = new PositionHolder();
    private boolean withered;

    public TreeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RuneCraftoryBlocks.TREE_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public void updateTreeLogs(BlockGetter level, Collection<BlockPos> pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(pos.stream().filter(p -> !p.equals((Object)this.getBlockPos().below())).toList());
        list.forEach(log -> {
            BlockEntity patt0$temp = level.getBlockEntity(log);
            if (patt0$temp instanceof TreeLogBlockEntity) {
                TreeLogBlockEntity logBlockEntity = (TreeLogBlockEntity)patt0$temp;
                logBlockEntity.updateTreeRoot(this.getBlockPos());
            }
        });
        this.logs.scheduleNewPositions(list);
        this.setChanged();
    }

    public void updateTreeLeaves(LevelAccessor level, Collection<BlockPos> pos) {
        this.leaves.scheduleNewPositions(pos);
        this.witherTree(level, this.withered, 0);
        this.setChanged();
    }

    public void updateTreeFruits(LevelAccessor level, Collection<BlockPos> pos) {
        this.fruits.scheduleNewPositions(pos);
        this.witherTree(level, this.withered, 1);
        this.setChanged();
    }

    public void invalidateUpdate() {
        this.logs.invalidateUpdate();
        this.leaves.invalidateUpdate();
        this.fruits.invalidateUpdate();
    }

    public boolean isTreeValid(BlockGetter getter) {
        for (BlockPos pos : this.logs.getPositions()) {
            TreeLogBlockEntity log;
            BlockEntity entity = getter.getBlockEntity(pos);
            if (entity instanceof TreeLogBlockEntity && (log = (TreeLogBlockEntity)entity).treeBase().equals((Object)this.getBlockPos())) continue;
            return false;
        }
        return true;
    }

    public boolean isPartOf(BlockPos pos) {
        return this.logs.getPositions().contains(pos);
    }

    public int getHealth() {
        if (this.getLevel() == null) {
            return -1;
        }
        if (this.getLevel().isClientSide) {
            FarmlandDataContainer data = ClientFarmlandHandler.INSTANCE.getData(this.getBlockPos().below());
            return data == null ? 0 : data.health();
        }
        ServerLevel serverLevel = (ServerLevel)this.getLevel();
        return FarmlandHandler.get(serverLevel.getServer()).getData(serverLevel, this.getBlockPos().below()).map(FarmlandData::getHealth).orElse(0);
    }

    public void onBreak(int cost) {
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        FarmlandHandler.get(serverLevel.getServer()).getData(serverLevel, this.getBlockPos().below()).ifPresent(d -> {
            d.modifyHealth(serverLevel, -cost);
            if (d.getHealth() <= 0) {
                this.onRemove((Level)serverLevel, this.getBlockPos(), true);
            }
        });
    }

    public void update(ServerLevel level) {
        for (BlockPos pos : this.fruits.getPositions()) {
            BlockState state = level.getBlockState(pos);
            if (!(state.getBlock() instanceof TreeFruitLeavesBlock)) continue;
            level.setBlock(pos, (BlockState)state.setValue((Property)TreeFruitLeavesBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        this.setChanged();
    }

    public void onRemove(Level level, BlockPos source, boolean particle) {
        List<BlockPos> logs = this.logs.getPositions();
        List<BlockPos> leaves = this.leaves.getPositions();
        List<BlockPos> fruits = this.fruits.getPositions();
        this.logs.scheduleNewPositions(List.of());
        this.leaves.scheduleNewPositions(List.of());
        this.fruits.scheduleNewPositions(List.of());
        logs.forEach(p -> this.removeBlock(level, (BlockPos)p, p.equals((Object)source) ? 2 : (particle ? 1 : 0)));
        leaves.forEach(p -> this.removeBlock(level, (BlockPos)p, p.equals((Object)source) ? 2 : (particle ? 1 : 0)));
        fruits.forEach(p -> this.removeBlock(level, (BlockPos)p, p.equals((Object)source) ? 2 : (particle ? 1 : 0)));
        if (!this.getBlockPos().equals((Object)source)) {
            this.removeBlock(level, this.getBlockPos(), 2);
        }
        this.setChanged();
    }

    private void removeBlock(Level level, BlockPos pos, int removeFlag) {
        switch (removeFlag) {
            case 2: {
                level.destroyBlock(pos, true);
                break;
            }
            case 1: {
                BlockState blockState = level.getBlockState(pos);
                level.levelEvent(2001, pos, Block.getId((BlockState)blockState));
                level.setBlock(pos, blockState.getFluidState().createLegacyBlock(), 2);
                break;
            }
            default: {
                BlockState blockState = level.getBlockState(pos);
                level.setBlock(pos, blockState.getFluidState().createLegacyBlock(), 2);
            }
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        ListTag logs = tag.getList("Logs", 11);
        logs.forEach(t -> this.logs.getPositions().add((BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, t).getOrThrow()));
        ListTag leaves = tag.getList("Leaves", 11);
        leaves.forEach(t -> this.leaves.getPositions().add((BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, t).getOrThrow()));
        ListTag fruits = tag.getList("Fruits", 11);
        fruits.forEach(t -> this.fruits.getPositions().add((BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, t).getOrThrow()));
        this.withered = tag.getBoolean("Withered");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag logs = new ListTag();
        this.logs.getPositions().forEach(p -> logs.add((Object)((Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, p).getOrThrow())));
        tag.put("Logs", (Tag)logs);
        ListTag leaves = new ListTag();
        this.leaves.getPositions().forEach(p -> leaves.add((Object)((Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, p).getOrThrow())));
        tag.put("Leaves", (Tag)leaves);
        ListTag fruits = new ListTag();
        this.fruits.getPositions().forEach(p -> fruits.add((Object)((Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, p).getOrThrow())));
        tag.put("Fruits", (Tag)fruits);
        tag.putBoolean("Withered", this.withered);
    }

    public void witherTree(LevelAccessor level, boolean wither) {
        this.witherTree(level, wither, 2);
    }

    private void witherTree(LevelAccessor level, boolean wither, int positions) {
        if (positions == 2 || positions == 0) {
            this.leaves.getPositions().forEach(p -> {
                BlockState state = level.getBlockState(p);
                if (state.hasProperty((Property)TreeLeavesBlock.WILTED) && (Boolean)state.getValue((Property)TreeLeavesBlock.WILTED) != wither) {
                    level.setBlock(p, (BlockState)state.setValue((Property)TreeLeavesBlock.WILTED, (Comparable)Boolean.valueOf(wither)), 3);
                }
            });
        }
        if (positions == 2 || positions == 1) {
            this.fruits.getPositions().forEach(p -> {
                BlockState state = level.getBlockState(p);
                if (state.hasProperty((Property)TreeLeavesBlock.WILTED) && (Boolean)state.getValue((Property)TreeLeavesBlock.WILTED) != wither) {
                    level.setBlock(p, (BlockState)state.setValue((Property)TreeLeavesBlock.WILTED, (Comparable)Boolean.valueOf(wither)), 3);
                }
            });
        }
        this.withered = wither;
    }

    public boolean withered() {
        return this.withered;
    }

    private static class PositionHolder {
        private Collection<BlockPos> toUpdate;
        private List<BlockPos> positions = new ArrayList<BlockPos>();

        private PositionHolder() {
        }

        public void invalidateUpdate() {
            this.toUpdate = null;
        }

        public void scheduleNewPositions(Collection<BlockPos> update) {
            this.getPositions();
            this.toUpdate = update;
        }

        public List<BlockPos> getPositions() {
            if (this.toUpdate != null) {
                this.positions = new ArrayList<BlockPos>(this.toUpdate);
            }
            return this.positions;
        }
    }
}

