/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryArmorEffects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;

public record ArmorEffectData(Optional<Holder<ArmorEffect>> first, Optional<Holder<ArmorEffect>> second, Optional<Holder<ArmorEffect>> third, int appendingIndex) {
    public static final ArmorEffectData DEFAULT = new ArmorEffectData(null, null, null, 0);
    public static final Codec<ArmorEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuneCraftoryArmorEffects.ARMOR_EFFECTS.registry().holderByNameCodec().optionalFieldOf("first_effect").forGetter(ArmorEffectData::first), (App)RuneCraftoryArmorEffects.ARMOR_EFFECTS.registry().holderByNameCodec().optionalFieldOf("second_effect").forGetter(ArmorEffectData::second), (App)RuneCraftoryArmorEffects.ARMOR_EFFECTS.registry().holderByNameCodec().optionalFieldOf("third_effect").forGetter(ArmorEffectData::third), (App)Codec.INT.fieldOf("idx").forGetter(d -> d.appendingIndex)).apply((Applicative)instance, ArmorEffectData::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, Optional<Holder<ArmorEffect>>> ARMOR_EFFECTS_CODEC = ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)RuneCraftoryArmorEffects.ARMOR_EFFECTS.registry().key()));
    public static final StreamCodec<RegistryFriendlyByteBuf, ArmorEffectData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ArmorEffectData>(){

        public ArmorEffectData decode(RegistryFriendlyByteBuf buf) {
            return new ArmorEffectData((Optional)ARMOR_EFFECTS_CODEC.decode((Object)buf), (Optional)ARMOR_EFFECTS_CODEC.decode((Object)buf), (Optional)ARMOR_EFFECTS_CODEC.decode((Object)buf), buf.readInt());
        }

        public void encode(RegistryFriendlyByteBuf buf, ArmorEffectData component) {
            ARMOR_EFFECTS_CODEC.encode((Object)buf, component.first());
            ARMOR_EFFECTS_CODEC.encode((Object)buf, component.second());
            ARMOR_EFFECTS_CODEC.encode((Object)buf, component.third());
            buf.writeInt(component.appendingIndex());
        }
    };

    public ArmorEffectData add(Holder<ArmorEffect> effect) {
        if (effect != null) {
            int next = (this.appendingIndex + 1) % 3;
            return switch (this.appendingIndex) {
                case 2 -> new ArmorEffectData(this.first, this.second, Optional.of(effect), next);
                case 1 -> new ArmorEffectData(this.first, Optional.of(effect), this.third, next);
                default -> new ArmorEffectData(Optional.of(effect), this.second, this.third, next);
            };
        }
        return this;
    }

    public void triggerEvent(ItemStack stack, Consumer<ArmorEffect> consumer) {
        if (this.first.isEmpty()) {
            DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).flatMap(ItemStat::getArmorEffect).ifPresent(effect -> {
                if (((ArmorEffect)effect.value()).canBeAppliedTo(stack)) {
                    consumer.accept((ArmorEffect)effect.value());
                }
            });
        } else {
            consumer.accept((ArmorEffect)this.first.get().value());
            this.second.ifPresent(eff -> consumer.accept((ArmorEffect)eff.value()));
            this.third.ifPresent(eff -> consumer.accept((ArmorEffect)eff.value()));
        }
    }
}

