/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.config;

import io.github.flemmli97.tenshilib.common.utils.SearchUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class DistanceZoningConfig {
    private static final Pair<Float, Zone> DEFAULT_VAL = Pair.of((Object)Float.valueOf(0.0f), (Object)new Zone(1, 0.01f));
    private final List<Pair<Float, Zone>> vals = new ArrayList<Pair>(List.of(Pair.of((Object)Float.valueOf(0.0f), (Object)new Zone(1, 0.0f)), Pair.of((Object)Float.valueOf(300.0f), (Object)new Zone(1, 0.0125f)), Pair.of((Object)Float.valueOf(2300.0f), (Object)new Zone(25, 0.01f)), Pair.of((Object)Float.valueOf(8300.0f), (Object)new Zone(105, 0.015f))));

    public DistanceZoningConfig readFromString(List<String> ss) {
        this.vals.clear();
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (String s : ss) {
            String[] parts = s.split("-");
            if (parts.length != 3) continue;
            list.add(Pair.of((Object)Float.valueOf(Float.parseFloat(parts[0])), (Object)new Zone((int)Float.parseFloat(parts[1]), Float.parseFloat(parts[2]))));
        }
        list.sort((o1, o2) -> Float.compare(((Float)o1.getLeft()).floatValue(), ((Float)o2.getLeft()).floatValue()));
        this.vals.addAll(list);
        return this;
    }

    public List<String> writeToString() {
        ArrayList<String> list = new ArrayList<String>();
        this.vals.forEach(v -> list.add(String.valueOf(v.getLeft()) + "-" + ((Zone)v.getRight()).start + "-" + ((Zone)v.getRight()).increasePerBlock));
        return list;
    }

    public Pair<Float, Zone> get(float dist) {
        return (Pair)SearchUtils.searchInfFunc(this.vals, v -> Float.compare(((Float)v.getLeft()).floatValue(), dist), DEFAULT_VAL);
    }

    public record Zone(int start, float increasePerBlock) {
    }
}

