/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.config;

import io.github.flemmli97.runecraftory.api.datapack.ExperienceCache;
import io.github.flemmli97.runecraftory.api.datapack.ExpressionHolder;
import io.github.flemmli97.runecraftory.common.config.ServerValue;
import io.github.flemmli97.runecraftory.common.items.ToolItemTier;

public class GeneralConfig {
    public static DefenceSystem defenceSystem = DefenceSystem.IGNORE_NONE;
    public static boolean gateSpawning = true;
    public static boolean disableVanillaSpawning = false;
    public static boolean randomDamage = true;
    public static RecipeSystem recipeSystem = RecipeSystem.SKILL;
    public static boolean useRp = true;
    public static float deathHpPercent = 1.0f;
    public static float deathRpPercent = 0.5f;
    public static boolean disableHunger = false;
    public static boolean modifyWeather = true;
    public static boolean modifyBed = false;
    public static boolean healOnWakeUp = true;
    public static boolean disableFoodSystem = false;
    public static boolean disableItemStatSystem = false;
    public static boolean disableCropSystem = false;
    public static boolean seasonedSnow = true;
    public static int maxPartySize = 3;
    public static boolean hotSpringSource;
    public static float witherChance;
    public static float runeyChance;
    public static boolean disableFarmlandRandomtick;
    public static boolean disableFarmlandTrample;
    public static boolean tickUnloadedFarmland;
    public static boolean unloadedFarmlandCheckWater;
    public static final ServerValue<Boolean> SERENE_SEASONS;
    public static int maxLevel;
    public static int startingHealth;
    public static int startingRp;
    public static int startingMoney;
    public static int startingStr;
    public static int startingVit;
    public static int startingIntel;
    public static float hpPerLevel;
    public static float rpPerLevel;
    public static float strPerLevel;
    public static float vitPerLevel;
    public static float intPerLevel;
    public static float shortSwordUltimate;
    public static float longSwordUltimate;
    public static float spearUltimate;
    public static float hammerAxeUltimate;
    public static float dualBladeUltimate;
    public static float gloveUltimate;
    public static float platinumChargeTime;
    public static int scrapWateringCanWater;
    public static int ironWateringCanWater;
    public static int silverWateringCanWater;
    public static int goldWateringCanWater;
    public static int platinumWateringCanWater;
    public static final ServerValue<Double> MOVE_SPEED_ATTACK;
    public static float xpMultiplier;
    public static float skillXpMultiplier;
    public static float tamingMultiplier;
    public static ExperienceCache experienceLevel;
    public static ExperienceCache friendPointsExperience;
    public static boolean debugAttack;

    public static int getWaterFrom(ToolItemTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case ToolItemTier.SCRAP -> 25;
            case ToolItemTier.IRON -> 35;
            case ToolItemTier.SILVER -> 100;
            case ToolItemTier.GOLD -> 150;
            case ToolItemTier.PLATINUM -> 250;
        };
    }

    static {
        witherChance = 0.5f;
        runeyChance = 0.05f;
        disableFarmlandRandomtick = true;
        disableFarmlandTrample = true;
        tickUnloadedFarmland = true;
        unloadedFarmlandCheckWater = true;
        SERENE_SEASONS = new ServerValue.SyncedBoolean(true, "config.integration.seasons");
        maxLevel = 999;
        startingHealth = 20;
        startingRp = 100;
        startingMoney = 100;
        startingStr = 1;
        startingVit = 0;
        startingIntel = 1;
        hpPerLevel = 3.0f;
        rpPerLevel = 2.0f;
        strPerLevel = 0.5f;
        vitPerLevel = 0.4f;
        intPerLevel = 0.5f;
        shortSwordUltimate = 7.0f;
        longSwordUltimate = 7.0f;
        spearUltimate = 7.0f;
        hammerAxeUltimate = 7.0f;
        dualBladeUltimate = 7.0f;
        gloveUltimate = 7.0f;
        platinumChargeTime = 0.5f;
        scrapWateringCanWater = 25;
        ironWateringCanWater = 35;
        silverWateringCanWater = 100;
        goldWateringCanWater = 150;
        platinumWateringCanWater = 250;
        MOVE_SPEED_ATTACK = new ServerValue.SyncedDouble(0.2, "config.move.attack");
        xpMultiplier = 1.0f;
        skillXpMultiplier = 1.0f;
        tamingMultiplier = 1.0f;
        experienceLevel = new ExperienceCache(() -> maxLevel, new ExpressionHolder("10 + level * 10 + 15 * level ^ 1.25 + (level / 10) * 250 + (level / 20) * (level / 20) * 1000"), true);
        friendPointsExperience = new ExperienceCache(() -> 20, new ExpressionHolder("level >= 10 ? 1000 : 45 + level * 5 + level * level * 10"), true);
        debugAttack = false;
    }

    public static enum DefenceSystem {
        NO_DEFENCE,
        VANILLA_IGNORE,
        IGNORE_VANILLA_MOBS,
        IGNORE_VANILLA_PLAYER_ATT,
        IGNORE_VANILLA_PLAYER_HURT,
        IGNORE_VANILLA_PLAYER,
        IGNORE_NONE;

    }

    public static enum RecipeSystem {
        SKILL(false, true, true),
        SKILLIGNORELOCK(false, true, false),
        SKILLBLOCKLOCK(false, false, false),
        BASE(true, true, true),
        BASEIGNORELOCK(true, true, false),
        BASEBLOCKLOCK(true, false, false);

        public final boolean baseCost;
        public final boolean allowLocked;
        public final boolean lockedCostMore;

        private RecipeSystem(boolean baseCost, boolean allowLocked, boolean lockedCostMore) {
            this.baseCost = baseCost;
            this.allowLocked = allowLocked;
            this.lockedCostMore = lockedCostMore;
        }

        public boolean lockIsIgnored() {
            return this.allowLocked && !this.lockedCostMore;
        }
    }
}

