/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack;

import com.google.gson.Gson;
import io.github.flemmli97.runecraftory.common.datapack.ListenerExtension;
import io.github.flemmli97.runecraftory.common.datapack.SyncableListener;
import io.github.flemmli97.runecraftory.common.datapack.manager.CropManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.FarmlandHoeTileActionManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.FoodManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.GateSpawnsManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.ItemStatManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.MonsterPropertiesManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.ShopItemsManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.SkillPropertiesManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.SpellPropertiesManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.StructureBossManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.GiftManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCActionManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCConversationManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCDataManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCLookManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NameManager;
import io.github.flemmli97.tenshilib.common.data.SyncedReloadListeners;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class DataPackHandler {
    public static final Gson GSON = new Gson();
    private static final Set<ListenerExtension> LISTENERS = new HashSet<ListenerExtension>();
    private static final Map<ResourceLocation, SyncableListener<?>> SYNCABLES = new HashMap();
    public static final DataPackHandler INSTANCE = new DataPackHandler();
    private final ItemStatManager itemStats = DataPackHandler.syncable(new ItemStatManager());
    private final CropManager crops = DataPackHandler.syncable(new CropManager());
    private final FoodManager foods = DataPackHandler.syncable(new FoodManager());
    private final ShopItemsManager shopItems = DataPackHandler.add(new ShopItemsManager());
    private final GateSpawnsManager gateSpawnsManager = DataPackHandler.add(new GateSpawnsManager());
    private final StructureBossManager structureBossManager = DataPackHandler.add(new StructureBossManager());
    private final MonsterPropertiesManager mobProperties = DataPackHandler.add(new MonsterPropertiesManager());
    private final SpellPropertiesManager spellProperties = DataPackHandler.add(new SpellPropertiesManager());
    private final SkillPropertiesManager skillPropertiesManager = DataPackHandler.add(new SkillPropertiesManager());
    private final FarmlandHoeTileActionManager fertilizerManager = DataPackHandler.add(new FarmlandHoeTileActionManager());
    private final NameManager names = DataPackHandler.add(new NameManager());
    private final GiftManager gifts = DataPackHandler.add(new GiftManager());
    private final NPCDataManager npcData = DataPackHandler.add(new NPCDataManager());
    private final NPCLookManager npcLooks = DataPackHandler.add(new NPCLookManager());
    private final NPCActionManager npcActions = DataPackHandler.add(new NPCActionManager());
    private final NPCConversationManager npcConversations = DataPackHandler.add(new NPCConversationManager());

    public static void addListeners(Consumer<ListenerExtension> cons) {
        LISTENERS.forEach(cons);
    }

    private static <T extends ListenerExtension> T add(T listener) {
        LISTENERS.add(listener);
        return listener;
    }

    private static <T extends SyncableListener<?>> T syncable(T listener) {
        SYNCABLES.put(listener.id(), listener);
        SyncedReloadListeners.addOrUpdate((ResourceLocation)listener.id(), listener);
        return DataPackHandler.add(listener);
    }

    private DataPackHandler() {
    }

    public ItemStatManager itemStatManager() {
        return this.itemStats;
    }

    public CropManager cropManager() {
        return this.crops;
    }

    public FoodManager foodManager() {
        return this.foods;
    }

    public ShopItemsManager shopItemsManager() {
        return this.shopItems;
    }

    public GateSpawnsManager gateSpawnsManager() {
        return this.gateSpawnsManager;
    }

    public StructureBossManager structureBossManager() {
        return this.structureBossManager;
    }

    public MonsterPropertiesManager monsterPropertiesManager() {
        return this.mobProperties;
    }

    public SpellPropertiesManager spellPropertiesManager() {
        return this.spellProperties;
    }

    public SkillPropertiesManager skillPropertiesManager() {
        return this.skillPropertiesManager;
    }

    public FarmlandHoeTileActionManager fertilizerManager() {
        return this.fertilizerManager;
    }

    public NameManager nameManager() {
        return this.names;
    }

    public GiftManager giftManager() {
        return this.gifts;
    }

    public NPCDataManager npcDataManager() {
        return this.npcData;
    }

    public NPCLookManager npcLookManager() {
        return this.npcLooks;
    }

    public NPCActionManager npcActionsManager() {
        return this.npcActions;
    }

    public NPCConversationManager npcConversationManager() {
        return this.npcConversations;
    }

    public <T> SyncableListener<T> getSyncable(ResourceLocation id) {
        return SYNCABLES.get(id);
    }
}

