/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.datapack.SyncableListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class CropManager
extends SimpleJsonResourceReloadListener
implements SyncableListener<Map<Item, ReloadableHolder<CropProperties>>> {
    public static final ResourceLocation ID = RuneCraftory.modRes("crop_property");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private static final StreamCodec<RegistryFriendlyByteBuf, ReloadableHolder<CropProperties>> HOLDER_CODEC = ReloadableHolder.streamCodec(CropProperties.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<Item, ReloadableHolder<CropProperties>>> CODEC = new StreamCodec<RegistryFriendlyByteBuf, Map<Item, ReloadableHolder<CropProperties>>>(){

        public Map<Item, ReloadableHolder<CropProperties>> decode(RegistryFriendlyByteBuf buf) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int size = buf.readVarInt();
            for (int i = 0; i < size; ++i) {
                builder.put((Object)((Item)ByteBufCodecs.registry((ResourceKey)Registries.ITEM).decode((Object)buf)), (Object)((ReloadableHolder)HOLDER_CODEC.decode((Object)buf)));
            }
            return builder.build();
        }

        public void encode(RegistryFriendlyByteBuf buf, Map<Item, ReloadableHolder<CropProperties>> props) {
            buf.writeVarInt(props.size());
            props.forEach((item, prop) -> {
                ByteBufCodecs.registry((ResourceKey)Registries.ITEM).encode((Object)buf, item);
                HOLDER_CODEC.encode((Object)buf, prop);
            });
        }
    };
    private Map<Item, ReloadableHolder<CropProperties>> itemLookup = ImmutableMap.of();
    private Map<Item, ReloadableHolder<CropProperties>> seedLookup = ImmutableMap.of();
    private Map<Block, ReloadableHolder<CropProperties>> blockLookup = ImmutableMap.of();
    private boolean resolved;
    private Set<ReloadableHolder<CropProperties>> unresolved = ImmutableSet.of();
    private HolderLookup.Provider provider;

    public CropManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    @Nullable
    public CropProperties get(Item item) {
        ReloadableHolder<CropProperties> value = this.getWithId(item);
        return value != null ? value.value() : null;
    }

    @Nullable
    public ReloadableHolder<CropProperties> getWithId(Item item) {
        if (GeneralConfig.disableCropSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.itemLookup.get(item);
    }

    @Nullable
    public CropProperties get(Block block) {
        ReloadableHolder<CropProperties> value = this.getWithId(block);
        return value != null ? value.value() : null;
    }

    @Nullable
    public ReloadableHolder<CropProperties> getWithId(Block block) {
        if (GeneralConfig.disableCropSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.blockLookup.get(block);
    }

    @Nullable
    public ReloadableHolder<CropProperties> getSeedWithId(Item item) {
        if (GeneralConfig.disableCropSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.seedLookup.get(item);
    }

    public void resolveTags(boolean forced) {
        if (!this.resolved || forced) {
            this.resolved = true;
            HashMap tagEntries = new HashMap();
            HashMap itemEntries = new HashMap();
            HashMap tagEntriesBlocks = new HashMap();
            HashMap itemEntriesBlocks = new HashMap();
            this.unresolved.stream().sorted(Comparator.comparing(ReloadableHolder::id)).forEach(entry -> {
                CropProperties.CropMappingInfo info = ((CropProperties)entry.value()).getInfo();
                if (info.seed() instanceof HolderSet.Named) {
                    info.seed().forEach(h -> tagEntries.put((Item)h.value(), entry));
                } else {
                    info.seed().forEach(h -> itemEntries.put((Item)h.value(), entry));
                }
                if (info.crop() instanceof HolderSet.Named) {
                    info.crop().forEach(h -> tagEntries.put((Item)h.value(), entry));
                } else {
                    info.crop().forEach(h -> itemEntries.put((Item)h.value(), entry));
                }
                if (info.cropBlock() instanceof HolderSet.Named) {
                    info.cropBlock().forEach(h -> tagEntriesBlocks.put((Block)h.value(), entry));
                } else {
                    info.cropBlock().forEach(h -> itemEntriesBlocks.put((Block)h.value(), entry));
                }
                info.giant().ifPresent(giant -> {
                    itemEntries.put((Item)giant.getFirst(), entry);
                    itemEntriesBlocks.put((Block)giant.getSecond(), entry);
                });
            });
            tagEntries.putAll(itemEntries);
            this.itemLookup = ImmutableMap.copyOf(tagEntries);
            HashMap seedEntries = new HashMap();
            this.itemLookup.forEach((item, prop) -> {
                if (((CropProperties)prop.value()).getInfo().seed().contains(BuiltInRegistries.ITEM.wrapAsHolder(item))) {
                    seedEntries.put(item, prop);
                }
            });
            this.seedLookup = ImmutableMap.copyOf(seedEntries);
            tagEntriesBlocks.putAll(itemEntriesBlocks);
            this.blockLookup = ImmutableMap.copyOf(tagEntriesBlocks);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.resolved = false;
        ImmutableSet.Builder toResolve = ImmutableSet.builder();
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> CropManager.lambda$apply$9((DynamicOps)ops, toResolve, arg_0, arg_1));
        this.unresolved = toResolve.build();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(HolderLookup.Provider provider) {
        this.provider = provider;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, Map<Item, ReloadableHolder<CropProperties>>> codec() {
        return CODEC;
    }

    @Override
    public Map<Item, ReloadableHolder<CropProperties>> toSync() {
        this.resolveTags(false);
        return Collections.unmodifiableMap(this.seedLookup);
    }

    @Override
    public void update(HolderLookup.Provider provider, Map<Item, ReloadableHolder<CropProperties>> value) {
        this.insertRegistryAccess(provider);
        this.seedLookup = value;
    }

    private static /* synthetic */ void lambda$apply$9(DynamicOps ops, ImmutableSet.Builder toResolve, ResourceLocation fres, JsonElement el) {
        try {
            CropProperties props = (CropProperties)CropProperties.CODEC.parse(ops, (Object)el).getOrThrow();
            toResolve.add(new ReloadableHolder<CropProperties>(fres, props));
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse crop properties json {} {}", (Object)fres, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }
}

