/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ListenerExtension;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class FarmlandHoeTileActionManager
extends SimpleJsonResourceReloadListener
implements ListenerExtension {
    public static final ResourceLocation ID = RuneCraftory.modRes("farmland_hoe_tile_action");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private Map<Item, Data> tileActions = ImmutableMap.of();
    private HolderLookup.Provider provider;

    public FarmlandHoeTileActionManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    @Nullable
    public Data get(Item item) {
        return this.tileActions.get(item);
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> FarmlandHoeTileActionManager.lambda$apply$0((DynamicOps)ops, entries, arg_0, arg_1));
        this.tileActions = entries.build();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(HolderLookup.Provider provider) {
        this.provider = provider;
    }

    private static /* synthetic */ void lambda$apply$0(DynamicOps ops, ImmutableMap.Builder entries, ResourceLocation fres, JsonElement el) {
        try {
            Data val = (Data)Data.CODEC.parse(ops, (Object)el).getOrThrow();
            entries.put((Object)val.item(), (Object)val);
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse hoe tile action json {} {}", (Object)fres, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }

    public record Data(Item item, int amount) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(Data::item), (App)Codec.INT.fieldOf("amount").forGetter(Data::amount)).apply((Applicative)instance, Data::new));
    }
}

