/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.datapack.SyncableListener;
import io.github.flemmli97.runecraftory.common.utils.HolderUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class FoodManager
extends SimpleJsonResourceReloadListener
implements SyncableListener<Map<Item, ReloadableHolder<FoodProperties>>> {
    public static final ResourceLocation ID = RuneCraftory.modRes("food_property");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private static final StreamCodec<RegistryFriendlyByteBuf, ReloadableHolder<FoodProperties>> HOLDER_CODEC = ReloadableHolder.streamCodec(FoodProperties.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<Item, ReloadableHolder<FoodProperties>>> CODEC = new StreamCodec<RegistryFriendlyByteBuf, Map<Item, ReloadableHolder<FoodProperties>>>(){

        public Map<Item, ReloadableHolder<FoodProperties>> decode(RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                builder.put((Object)((Item)ByteBufCodecs.registry((ResourceKey)Registries.ITEM).decode((Object)buf)), (Object)((ReloadableHolder)HOLDER_CODEC.decode((Object)buf)));
            }
            return builder.build();
        }

        public void encode(RegistryFriendlyByteBuf buf, Map<Item, ReloadableHolder<FoodProperties>> props) {
            buf.writeVarInt(props.size());
            props.forEach((item, prop) -> {
                ByteBufCodecs.registry((ResourceKey)Registries.ITEM).encode((Object)buf, item);
                HOLDER_CODEC.encode((Object)buf, prop);
            });
        }
    };
    private Map<Item, ReloadableHolder<FoodProperties>> food = ImmutableMap.of();
    private boolean resolved;
    private Map<TagKey<Item>, ReloadableHolder<FoodProperties>> tagFood = ImmutableMap.of();
    private HolderLookup.Provider provider;

    public FoodManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    @Nullable
    public FoodProperties get(Item item) {
        ReloadableHolder<FoodProperties> value = this.getWithId(item);
        return value != null ? value.value() : null;
    }

    @Nullable
    public ReloadableHolder<FoodProperties> getWithId(Item item) {
        if (GeneralConfig.disableFoodSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.food.get(item);
    }

    public void resolveTags(boolean forced) {
        if (!this.resolved || forced) {
            this.resolved = true;
            HashMap<Item, ReloadableHolder<FoodProperties>> itemEntries = new HashMap<Item, ReloadableHolder<FoodProperties>>(this.food);
            this.tagFood.entrySet().stream().sorted(Comparator.comparing(e -> ((TagKey)e.getKey()).location())).forEach(entry -> HolderUtils.expandTag(this.provider, Registries.ITEM, (TagKey)entry.getKey()).forEach(item -> {
                if (!itemEntries.containsKey(item)) {
                    itemEntries.put((Item)item, (ReloadableHolder)entry.getValue());
                }
            }));
            this.food = ImmutableMap.copyOf(itemEntries);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.resolved = false;
        ImmutableMap.Builder itemEntries = ImmutableMap.builder();
        ImmutableMap.Builder tagEntries = ImmutableMap.builder();
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> this.lambda$apply$4(tagEntries, (DynamicOps)ops, itemEntries, arg_0, arg_1));
        this.food = itemEntries.build();
        this.tagFood = tagEntries.build();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(HolderLookup.Provider provider) {
        this.provider = provider;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, Map<Item, ReloadableHolder<FoodProperties>>> codec() {
        return CODEC;
    }

    @Override
    public Map<Item, ReloadableHolder<FoodProperties>> toSync() {
        this.resolveTags(false);
        return Collections.unmodifiableMap(this.food);
    }

    @Override
    public void update(HolderLookup.Provider provider, Map<Item, ReloadableHolder<FoodProperties>> value) {
        this.insertRegistryAccess(provider);
        this.food = value;
    }

    private /* synthetic */ void lambda$apply$4(ImmutableMap.Builder tagEntries, DynamicOps ops, ImmutableMap.Builder itemEntries, ResourceLocation fres, JsonElement el) {
        try {
            JsonObject obj = el.getAsJsonObject();
            String key = GsonHelper.getAsString((JsonObject)obj, (String)"item");
            if (key.startsWith("#")) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)key.substring(1)));
                tagEntries.put((Object)tag, new ReloadableHolder<FoodProperties>(fres, (FoodProperties)FoodProperties.CODEC.parse(ops, (Object)el).getOrThrow()));
            } else {
                Optional<Item> item = HolderUtils.get(this.provider, Registries.ITEM, ResourceLocation.parse((String)key));
                item.ifPresent(i -> itemEntries.put(i, new ReloadableHolder<FoodProperties>(fres, (FoodProperties)FoodProperties.CODEC.parse(ops, (Object)el).getOrThrow())));
            }
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse food stat json {} {}", (Object)fres, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }
}

