/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.datapack.SyncableListener;
import io.github.flemmli97.runecraftory.common.utils.HolderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStatManager
extends SimpleJsonResourceReloadListener
implements SyncableListener<Map<Item, ReloadableHolder<ItemStat>>> {
    public static final ResourceLocation ID = RuneCraftory.modRes("item_property");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private static final StreamCodec<RegistryFriendlyByteBuf, ReloadableHolder<ItemStat>> HOLDER_CODEC = ReloadableHolder.streamCodec(ItemStat.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<Item, ReloadableHolder<ItemStat>>> CODEC = new StreamCodec<RegistryFriendlyByteBuf, Map<Item, ReloadableHolder<ItemStat>>>(){

        public Map<Item, ReloadableHolder<ItemStat>> decode(RegistryFriendlyByteBuf buf) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int size = buf.readVarInt();
            for (int i = 0; i < size; ++i) {
                builder.put((Object)((Item)ByteBufCodecs.registry((ResourceKey)Registries.ITEM).decode((Object)buf)), (Object)((ReloadableHolder)HOLDER_CODEC.decode((Object)buf)));
            }
            return builder.build();
        }

        public void encode(RegistryFriendlyByteBuf buf, Map<Item, ReloadableHolder<ItemStat>> props) {
            buf.writeVarInt(props.size());
            props.forEach((item, prop) -> {
                ByteBufCodecs.registry((ResourceKey)Registries.ITEM).encode((Object)buf, item);
                HOLDER_CODEC.encode((Object)buf, prop);
            });
        }
    };
    private Map<Item, ReloadableHolder<ItemStat>> itemstats = ImmutableMap.of();
    private boolean resolved;
    private Map<TagKey<Item>, ReloadableHolder<ItemStat>> tagStats = ImmutableMap.of();
    private HolderLookup.Provider provider;

    public ItemStatManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    public Optional<ItemStat> get(Item item) {
        return this.getWithId(item).map(ReloadableHolder::value);
    }

    public Optional<ReloadableHolder<ItemStat>> getWithId(Item item) {
        if (GeneralConfig.disableItemStatSystem) {
            return Optional.empty();
        }
        this.resolveTags(false);
        return Optional.ofNullable(this.itemstats.get(item));
    }

    public List<Pair<ItemStack, ReloadableHolder<ItemStat>>> all() {
        return this.all(t -> true);
    }

    public List<Pair<ItemStack, ReloadableHolder<ItemStat>>> all(Predicate<ItemStack> test) {
        ArrayList<Pair<ItemStack, ReloadableHolder<ItemStat>>> list = new ArrayList<Pair<ItemStack, ReloadableHolder<ItemStat>>>();
        this.itemstats.forEach((item, stat) -> {
            ItemStack stack = item.getDefaultInstance();
            if (!stack.isEmpty() && test.test(stack)) {
                list.add(Pair.of((Object)stack, (Object)stat));
            }
        });
        return list;
    }

    public void resolveTags(boolean forced) {
        if (!this.resolved || forced) {
            this.resolved = true;
            HashMap<Item, ReloadableHolder<ItemStat>> itemEntries = new HashMap<Item, ReloadableHolder<ItemStat>>(this.itemstats);
            this.tagStats.entrySet().stream().sorted(Comparator.comparing(e -> ((TagKey)e.getKey()).location())).forEach(entry -> HolderUtils.expandTag(this.provider, Registries.ITEM, (TagKey)entry.getKey()).forEach(item -> {
                if (!itemEntries.containsKey(item)) {
                    itemEntries.put((Item)item, (ReloadableHolder)entry.getValue());
                }
            }));
            this.itemstats = ImmutableMap.copyOf(itemEntries);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.resolved = false;
        ImmutableMap.Builder itemEntries = ImmutableMap.builder();
        ImmutableMap.Builder tagEntries = ImmutableMap.builder();
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> this.lambda$apply$6((DynamicOps)ops, tagEntries, itemEntries, arg_0, arg_1));
        this.itemstats = itemEntries.build();
        this.tagStats = tagEntries.build();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(HolderLookup.Provider provider) {
        this.provider = provider;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, Map<Item, ReloadableHolder<ItemStat>>> codec() {
        return CODEC;
    }

    @Override
    public Map<Item, ReloadableHolder<ItemStat>> toSync() {
        this.resolveTags(false);
        return Collections.unmodifiableMap(this.itemstats);
    }

    @Override
    public void update(HolderLookup.Provider provider, Map<Item, ReloadableHolder<ItemStat>> value) {
        this.insertRegistryAccess(provider);
        this.itemstats = value;
    }

    private /* synthetic */ void lambda$apply$6(DynamicOps ops, ImmutableMap.Builder tagEntries, ImmutableMap.Builder itemEntries, ResourceLocation fres, JsonElement el) {
        try {
            JsonObject obj = el.getAsJsonObject();
            String key = GsonHelper.getAsString((JsonObject)obj, (String)"item");
            if (key.startsWith("#")) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)key.substring(1)));
                ItemStat props = (ItemStat)ItemStat.CODEC.parse(ops, (Object)el).getOrThrow();
                tagEntries.put((Object)tag, new ReloadableHolder<ItemStat>(fres, props));
            } else {
                Optional<Item> item = HolderUtils.get(this.provider, Registries.ITEM, ResourceLocation.parse((String)key));
                item.ifPresent(i -> {
                    ItemStat props = (ItemStat)ItemStat.CODEC.parse(ops, (Object)el).getOrThrow();
                    itemEntries.put(i, new ReloadableHolder<ItemStat>(fres, props));
                });
            }
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse item stat json {} {}", (Object)fres, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }
}

