/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ListenerExtension;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import io.github.flemmli97.runecraftory.common.utils.HolderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;

public class ShopItemsManager
extends SimpleJsonResourceReloadListener
implements ListenerExtension {
    public static final ResourceLocation ID = RuneCraftory.modRes("shop_item");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private Map<NPCProfession, Collection<ShopItemProperties>> shopItems = ImmutableMap.of();
    private Map<NPCProfession, Collection<ShopItemProperties>> shopItemsDefaults = ImmutableMap.of();
    private boolean resolved;
    private Map<NPCProfession, Collection<ShopItemProperties.IntermediaryShopItem>> intermediaryData = ImmutableMap.of();
    private HolderLookup.Provider provider;

    public ShopItemsManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    public Collection<ShopItemProperties> get(NPCProfession shop) {
        this.resolve();
        return this.shopItems.getOrDefault(shop, Collections.emptyList());
    }

    public Collection<ShopItemProperties> getDefaultItems(NPCProfession shop) {
        this.resolve();
        return this.shopItemsDefaults.getOrDefault(shop, Collections.emptyList());
    }

    public void resolve() {
        if (!this.resolved) {
            this.resolved = true;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap.Builder defaultsBuilder = ImmutableMap.builder();
            this.intermediaryData.forEach((profession, items) -> {
                ArrayList newCollection = new ArrayList();
                ArrayList defaultCollection = new ArrayList();
                items.forEach(props -> {
                    List<ShopItemProperties> contents = ShopItemProperties.from(this.provider, props);
                    contents.forEach(prop -> {
                        if (DataPackHandler.INSTANCE.itemStatManager().get(prop.stack().getItem()).map(ItemStat::getBuy).orElse(0) > 0) {
                            if (prop.unlockType() == ShopItemProperties.UnlockType.DEFAULT) {
                                defaultCollection.add(prop);
                            } else {
                                newCollection.add(prop);
                            }
                        }
                    });
                });
                builder.put(profession, (Object)ImmutableList.copyOf(newCollection));
                defaultsBuilder.put(profession, (Object)ImmutableList.copyOf(defaultCollection));
            });
            builder.put((Object)((NPCProfession)RuneCraftoryNPCProfessions.TRAVELLING_MERCHANT.get()), DataPackHandler.INSTANCE.itemStatManager().all().stream().filter(p -> ((ItemStat)((ReloadableHolder)p.getSecond()).value()).getBuy() > 0).map(p -> new ShopItemProperties((ItemStack)p.getFirst(), ShopItemProperties.UnlockType.NEEDS_SHIPPING, Optional.empty())).toList());
            this.shopItems = builder.build();
            this.shopItemsDefaults = defaultsBuilder.build();
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<NPCProfession, Collection<ShopItemProperties.IntermediaryShopItem>> shops = new HashMap<NPCProfession, Collection<ShopItemProperties.IntermediaryShopItem>>();
        this.resolved = false;
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> this.lambda$apply$7((DynamicOps)ops, shops, arg_0, arg_1));
        this.intermediaryData = shops;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(HolderLookup.Provider provider) {
        this.provider = provider;
    }

    private /* synthetic */ void lambda$apply$7(DynamicOps ops, HashMap shops, ResourceLocation fres, JsonElement el) {
        try {
            Optional optionalProfession = HolderUtils.get(this.provider, RuneCraftoryNPCProfessions.PROFESSION_REGISTRY_KEY, fres);
            if (optionalProfession.isEmpty() || !((NPCProfession)optionalProfession.get()).hasShop) {
                return;
            }
            NPCProfession profession = (NPCProfession)optionalProfession.get();
            JsonObject obj = el.getAsJsonObject();
            boolean replace = GsonHelper.getAsBoolean((JsonObject)obj, (String)"replace", (boolean)false);
            JsonArray array = GsonHelper.getAsJsonArray((JsonObject)obj, (String)"values");
            ArrayList contents = new ArrayList();
            array.forEach(val -> {
                ShopItemProperties.IntermediaryShopItem prop = (ShopItemProperties.IntermediaryShopItem)ShopItemProperties.CODEC.parse(ops, val).getOrThrow();
                contents.add(prop);
            });
            if (replace) {
                shops.put(profession, contents);
            } else {
                shops.compute(profession, (k, v) -> {
                    if (v == null) {
                        return contents;
                    }
                    v.addAll(contents);
                    return v;
                });
            }
        }
        catch (JsonSyntaxException ex) {
            RuneCraftory.LOGGER.error("Couldn't parse shop stack json {} {}", (Object)fres, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }
}

