/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.SpellProperties;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ListenerExtension;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.HolderUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class SpellPropertiesManager
extends SimpleJsonResourceReloadListener
implements ListenerExtension {
    public static final ResourceLocation ID = RuneCraftory.modRes("spell");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private Map<Spell, SpellProperties> propertiesMap = new HashMap<Spell, SpellProperties>();
    private HolderLookup.Provider provider;

    public SpellPropertiesManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    public SpellProperties getPropertiesFor(Spell spell) {
        return this.propertiesMap.getOrDefault(spell, SpellProperties.DEFAULT_PROP);
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder propertiesBuilder = new ImmutableMap.Builder();
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> this.lambda$apply$1((DynamicOps)ops, propertiesBuilder, arg_0, arg_1));
        this.propertiesMap = propertiesBuilder.build();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(HolderLookup.Provider provider) {
        this.provider = provider;
    }

    private /* synthetic */ void lambda$apply$1(DynamicOps ops, ImmutableMap.Builder propertiesBuilder, ResourceLocation key, JsonElement el) {
        try {
            Spell spell = (Spell)HolderUtils.get(this.provider, RuneCraftorySpells.SPELL_REGISTRY_KEY, key).orElseThrow(() -> new NoSuchElementException("Spell with id " + String.valueOf(key) + " doesn't exist"));
            SpellProperties props = (SpellProperties)SpellProperties.CODEC.parse(ops, (Object)el).getOrThrow();
            propertiesBuilder.put((Object)spell, (Object)props);
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse spell properties json {} {}", (Object)key, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }
}

