/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import io.github.flemmli97.runecraftory.common.utils.BlockPlaceCtxHelper;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;

public class TendCrops<E extends BaseMonster>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORIES = MemoryTest.builder((int)1).hasMemory((MemoryModuleType)RuneCraftoryMemoryTypes.FARMING.get());
    private static final Predicate<ItemStack> SEED_ITEM = s -> !s.isEmpty() && s.getItem() instanceof BlockItem && (s.is(RunecraftoryTags.Items.SEEDS) || s.getItem() == Items.POTATO || s.getItem() == Items.CARROT);
    private final List<BlockPos> toTend = new ArrayList<BlockPos>();
    private BlockPos selected;
    private int cooldown;
    private boolean canPlant;

    public static boolean cantTendToCropsAnymore(BaseMonster monster) {
        return (double)Mth.floor((float)monster.getHealth()) <= Math.max(1.0, (double)monster.getMaxHealth() * 0.05);
    }

    public static void setHealthTo(BaseMonster monster, float health) {
        monster.setHealth(Math.max(health, monster.getMaxHealth() * 0.05f));
    }

    public TendCrops() {
        this.cooldownFor(e -> 40);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return !TendCrops.cantTendToCropsAnymore(entity) && entity.hasRestriction();
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return !this.toTend.isEmpty();
    }

    protected void start(E entity) {
        this.toTend.clear();
        this.canPlant = ((BaseMonster)entity).getSeedInventory() != null && Platform.INSTANCE.matchingInventory(entity.level().getBlockEntity(((BaseMonster)entity).getSeedInventory()), SEED_ITEM);
        BlockPos center = entity.getRestrictCenter();
        BlockPos.MutableBlockPos mutable = entity.getRestrictCenter().mutable();
        int radius = MobConfig.farmRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    mutable.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                    if (!this.validPos((BlockPos)mutable, entity.level())) continue;
                    this.toTend.add(new BlockPos((Vec3i)mutable));
                }
            }
        }
        if (!this.toTend.isEmpty()) {
            this.selected = this.toTend.remove(entity.getRandom().nextInt(this.toTend.size()));
        }
    }

    private boolean validPos(BlockPos pos, Level level) {
        CropBlock crop;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(state)) {
            return true;
        }
        BlockState state2 = level.getBlockState(pos.below());
        if (state2.is(RunecraftoryTags.Blocks.FARMLAND) && (Integer)state2.getValue((Property)FarmBlock.MOISTURE) < 7) {
            return true;
        }
        if (state2.getBlock() instanceof FarmBlock) {
            if (state.is(RunecraftoryTags.Blocks.MONSTER_CLEARABLE)) {
                return true;
            }
            if (this.canPlant) {
                return state.isAir();
            }
        }
        return false;
    }

    protected void tick(E entity) {
        if (entity.getAnimationHandler().hasAnimation() || --this.cooldown > 0) {
            return;
        }
        if (this.selected == null) {
            if (this.toTend.isEmpty()) {
                return;
            }
            this.selected = this.toTend.remove(entity.getRandom().nextInt(this.toTend.size()));
            boolean bl = this.canPlant = ((BaseMonster)entity).getSeedInventory() != null && Platform.INSTANCE.matchingInventory(entity.level().getBlockEntity(((BaseMonster)entity).getSeedInventory()), SEED_ITEM);
            if (!this.validPos(this.selected, entity.level())) {
                this.selected = null;
                this.cooldown = 10;
                return;
            }
        }
        if (!this.selected.closerToCenterThan((Position)entity.position(), Math.max(1.1, (double)entity.getBbWidth() * 1.9))) {
            Vec3 to = Vec3.atCenterOf((Vec3i)this.selected);
            Path path = entity.getNavigation().createPath(to.x(), to.y(), to.z(), 0);
            entity.getNavigation().moveTo(path, 1.0);
            this.cooldown = entity.getRandom().nextInt(5) + 5;
        } else {
            BlockPos selected = this.selected;
            BlockState state = entity.level().getBlockState(selected);
            Block block = state.getBlock();
            Runnable run = () -> {
                CropBlock crop;
                boolean success = false;
                if (state.is(RunecraftoryTags.Blocks.MONSTER_CLEARABLE)) {
                    TendCrops.breakBlock(entity, selected, entity.getCropInventory() != null ? s -> Platform.INSTANCE.insertInto(entity.level().getBlockEntity(entity.getCropInventory()), (ItemStack)s) : null);
                } else if (block instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(state)) {
                    CropUtils.harvestCropRightClick(state, entity.level(), selected, (Entity)entity, ItemStack.EMPTY, DataPackHandler.INSTANCE.cropManager().get((Block)crop), InteractionHand.MAIN_HAND, entity.getCropInventory() != null ? s -> Platform.INSTANCE.insertInto(entity.level().getBlockEntity(entity.getCropInventory()), (ItemStack)s) : null);
                    entity.level().getEntities(EntityTypeTest.forClass(ItemEntity.class), entity.getBoundingBox().inflate(0.2), e -> true);
                    success = true;
                } else {
                    BlockPos pos = selected.below();
                    BlockState state2 = entity.level().getBlockState(pos);
                    if (state2.is(RunecraftoryTags.Blocks.FARMLAND)) {
                        Item patt0$temp;
                        ItemStack stack;
                        if ((Integer)state2.getValue((Property)FarmBlock.MOISTURE) < 7) {
                            FarmlandHandler.waterLand((ServerLevel)entity.level(), pos, state2);
                            success = true;
                        } else if (state.isAir() && entity.getSeedInventory() != null && !(stack = Platform.INSTANCE.findMatchingItem(entity.level().getBlockEntity(entity.getSeedInventory()), SEED_ITEM, 1)).isEmpty() && (patt0$temp = stack.getItem()) instanceof BlockItem) {
                            BlockItem blockItem = (BlockItem)patt0$temp;
                            blockItem.place(BlockPlaceCtxHelper.entityPlaceAt(entity.level(), stack, selected, Direction.UP));
                            entity.level().setBlock(selected, blockItem.getBlock().defaultBlockState(), 3);
                            entity.level().playSound(null, (double)selected.getX(), (double)selected.getY(), (double)selected.getZ(), SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                            stack.shrink(1);
                            success = true;
                        }
                    }
                }
                if (success) {
                    entity.addXp(5 + entity.getRandom().nextInt(5));
                }
            };
            ((BaseMonster)entity).runInteractHandling(run);
            this.selected = null;
            this.cooldown = entity.getRandom().nextInt(15) + 20;
        }
    }

    public void stop(E entity) {
        super.stop(entity);
        this.toTend.clear();
        this.selected = null;
    }

    private static <E extends Entity> void breakBlock(E entity, BlockPos pos, Function<ItemStack, ItemStack> stackConsumer) {
        BlockEntity blockEntity;
        ServerLevel level = (ServerLevel)entity.level();
        BlockState state = level.getBlockState(pos);
        level.levelEvent(2001, pos, Block.getId((BlockState)state));
        BlockEntity blockEntity2 = blockEntity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        if (stackConsumer != null) {
            Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, entity, (ItemStack)ItemStack.EMPTY).forEach(s -> {
                ItemStack rest = (ItemStack)stackConsumer.apply((ItemStack)s);
                if (!rest.isEmpty()) {
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)rest);
                }
            });
            state.spawnAfterBreak(level, pos, ItemStack.EMPTY, false);
        } else {
            Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, entity, (ItemStack)ItemStack.EMPTY);
        }
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
    }
}

