/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetRainShelterTarget<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final Predicate<Holder<PoiType>> HIDING_POIS = poi -> RuneCraftoryNPCProfessions.PROFESSIONS.registry().stream().anyMatch(j -> j.matches((Holder<PoiType>)poi));
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).noMemory(MemoryModuleType.WALK_TARGET).usesMemories(new MemoryModuleType[]{MemoryModuleType.HIDING_PLACE}).usesMemories(new MemoryModuleType[]{MemoryModuleType.HOME}).usesMemories(new MemoryModuleType[]{MemoryModuleType.JOB_SITE});
    protected ToDoubleFunction<E> range = e -> 10.0;
    protected ToIntFunction<E> wanderChance = e -> e.getRandom().nextInt(80);
    private WalkTarget target;

    public SetRainShelterTarget() {
        this.cooldownFor(e -> 20);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (!level.isRaining()) {
            return false;
        }
        this.target = this.findWalkTarget(entity);
        return this.target != null;
    }

    protected void start(E entity) {
        if (this.target != null) {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)this.target);
        }
    }

    protected WalkTarget findWalkTarget(E entity) {
        GlobalPos hide = (GlobalPos)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.HIDING_PLACE);
        if (hide == null || hide.dimension() != entity.level().dimension()) {
            hide = this.findHidingPlace(entity);
        }
        if (hide != null) {
            double range = this.range.applyAsDouble(entity);
            Vec3 target = null;
            float spd = 1.0f;
            int acc = 0;
            if (entity.distanceToSqr((double)hide.pos().getX() + 0.5, (double)hide.pos().getY(), (double)hide.pos().getZ() + 0.5) > range * range || this.isInRain(entity)) {
                target = Vec3.atBottomCenterOf((Vec3i)hide.pos());
                spd = 1.3f;
                acc = 3;
            } else if (this.wanderChance.applyAsInt(entity) == 0) {
                target = this.getWanderPos(entity, hide.pos(), (int)range);
            }
            if (target != null) {
                return new WalkTarget(target, spd, acc);
            }
        }
        return null;
    }

    protected GlobalPos findHidingPlace(E entity) {
        PoiManager poiManager = ((ServerLevel)entity.level()).getPoiManager();
        GlobalPos home = (GlobalPos)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.HOME);
        GlobalPos work = (GlobalPos)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.JOB_SITE);
        Set set = poiManager.findAllClosestFirstWithType(HIDING_POIS, p -> {
            if (home != null && home.dimension() == entity.level().dimension()) {
                return entity.blockPosition().distSqr((Vec3i)home.pos()) > entity.blockPosition().distSqr((Vec3i)p);
            }
            return true;
        }, entity.blockPosition(), 64, PoiManager.Occupancy.ANY).limit(5L).collect(Collectors.toSet());
        GlobalPos found = null;
        for (Pair pos : set) {
            AABB atPos = new AABB((BlockPos)pos.getSecond()).inflate(10.0);
            if (entity.level().getEntities(EntityTypeTest.forClass(NPCEntity.class), atPos, e -> true).size() >= 5 || !this.isUnderRoof(entity, (BlockPos)pos.getSecond())) continue;
            found = GlobalPos.of((ResourceKey)entity.level().dimension(), (BlockPos)((BlockPos)pos.getSecond()));
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.HIDING_PLACE, (Object)found);
            break;
        }
        if (found == null) {
            if (home != null && home.dimension() == entity.level().dimension() && this.isUnderRoof(entity, home.pos())) {
                found = home;
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.HIDING_PLACE, (Object)found);
            } else if (work != null && work.dimension() == entity.level().dimension() && this.isUnderRoof(entity, work.pos())) {
                found = work;
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.HIDING_PLACE, (Object)found);
            }
        }
        return found;
    }

    protected boolean isUnderRoof(E entity, BlockPos pos) {
        return BlockPos.betweenClosedStream((BlockPos)pos.offset(-2, 1, -2), (BlockPos)pos.offset(2, 1, 2)).noneMatch(p -> entity.level().canSeeSky(p) && entity.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, p).getY() <= p.getY());
    }

    protected boolean isInRain(E entity) {
        return this.isInRain(entity.level(), BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ()));
    }

    protected boolean isInRain(Level level, BlockPos pos) {
        return level.isRainingAt(pos);
    }

    protected Vec3 getWanderPos(E entity, BlockPos around, int radius) {
        for (int i = 0; i < 5; ++i) {
            Vec3 target = LandRandomPos.getPos(entity, (int)radius, (int)radius);
            if (target == null || !(target.distanceToSqr((double)around.getX() + 0.5, (double)around.getY(), (double)around.getZ() + 0.5) < (double)radius) || this.isInRain(entity.level(), BlockPos.containing((Position)target))) continue;
            return target;
        }
        return null;
    }
}

