/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.NPCAttackAction;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetSpellAttack<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).usesMemories(new MemoryModuleType[]{(MemoryModuleType)RuneCraftoryMemoryTypes.NPC_ATTACK_ACTION.get()});
    private final Spell spell;
    private final ToIntFunction<E> combos;

    public SetSpellAttack(Spell spell, ToIntFunction<E> combos) {
        this.spell = spell;
        this.combos = combos;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        AttackAction act = this.spell.useAction();
        int combos = act.combos() == null ? 1 : Mth.clamp((int)this.combos.applyAsInt(entity), (int)1, (int)act.combos().size());
        NPCAttackAction action = new NPCAttackAction(act, combos, Optional.of(this.spell));
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.NPC_ATTACK_ACTION.get()), (Object)action);
    }
}

