/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.components.AttackActionData;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.NPCAttackAction;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWeaponBasedAttack<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).usesMemories(new MemoryModuleType[]{(MemoryModuleType)RuneCraftoryMemoryTypes.NPC_ATTACK_ACTION.get()});

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (!super.checkExtraStartConditions(level, entity)) {
            return false;
        }
        ItemStack weapon = entity.getMainHandItem();
        AttackActionData action = (AttackActionData)weapon.get((DataComponentType)RuneCraftoryDataComponentTypes.ATTACK_ACTION.get());
        return action != null && ((Optional)action.attackAction().get()).isPresent();
    }

    protected void start(E entity) {
        super.start(entity);
        ItemStack weapon = entity.getMainHandItem();
        AttackActionData action = (AttackActionData)weapon.get((DataComponentType)RuneCraftoryDataComponentTypes.ATTACK_ACTION.get());
        Object opt = action.attackAction().get();
        int amount = Math.min(3, entity.getRandom().nextInt(((AttackAction)((Holder)((Optional)opt).get()).value()).combos().size()) + 1);
        NPCAttackAction attackAction = new NPCAttackAction((AttackAction)((Holder)((Optional)opt).get()).value(), amount, Optional.empty());
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.NPC_ATTACK_ACTION.get()), (Object)attackAction);
    }
}

