/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SleepInBed<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)2).hasMemories(new MemoryModuleType[]{MemoryModuleType.HOME}).usesMemories(new MemoryModuleType[]{MemoryModuleType.LAST_WOKEN});
    protected int retryCooldown = 100;

    public SleepInBed() {
        this.noTimeout();
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (entity.isPassenger()) {
            return false;
        }
        GlobalPos pos = (GlobalPos)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.HOME);
        if (level.dimension() != pos.dimension()) {
            return false;
        }
        Long last = (Long)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.LAST_WOKEN);
        if (last != null && Math.abs(level.getGameTime() - last) < (long)this.retryCooldown) {
            return false;
        }
        return pos.pos().closerToCenterThan((Position)entity.position(), 2.0) && this.canSleepInBed(entity, pos.pos());
    }

    protected boolean canSleepInBed(E entity, BlockPos pos) {
        BlockState blockState = entity.level().getBlockState(pos);
        return blockState.is(BlockTags.BEDS) && (Boolean)blockState.getValue((Property)BedBlock.OCCUPIED) == false;
    }

    protected void start(E entity) {
        entity.startSleeping(((GlobalPos)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.HOME)).pos());
    }

    protected boolean shouldKeepRunning(E entity) {
        GlobalPos pos = (GlobalPos)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.HOME);
        if (pos == null) {
            return false;
        }
        BlockPos blockPos = pos.pos();
        return entity.getBrain().isActive(Activity.REST) && entity.getY() > (double)blockPos.getY() + 0.4 && blockPos.closerToCenterThan((Position)entity.position(), 1.14);
    }

    protected void stop(E entity) {
        if (entity.isSleeping()) {
            entity.stopSleeping();
        }
    }
}

