/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class AmbrosiaWaveEntity
extends BaseDamageCloud {
    private static final EntityDataAccessor<Integer> MAX_TICK = SynchedEntityData.defineId(AmbrosiaWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final List<Vector3f> CIRCLE_PARTICLE_MOTION = MathUtils.rotatedVecs((Vector3f)new Vector3f(0.3f, 0.0f, 0.0f), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (float)-180.0f, (float)175.0f, (float)5.0f);
    private final Set<FrozenEntity> hitEntityPos = new HashSet<FrozenEntity>();

    public AmbrosiaWaveEntity(EntityType<? extends AmbrosiaWaveEntity> type, Level level) {
        super(type, level);
        this.damageMultiplier = 0.3f;
    }

    public AmbrosiaWaveEntity(Level level, LivingEntity shooter, int maxLivingTick) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.AMBROSIA_WAVE.get()), level, shooter);
        this.entityData.set(MAX_TICK, (Object)maxLivingTick);
        this.damageMultiplier = 0.3f;
    }

    public float radiusIncrease() {
        return 0.45f;
    }

    public double maxRadius() {
        return 6.5;
    }

    public int livingTickMax() {
        return (Integer)this.entityData.get(MAX_TICK);
    }

    public boolean canStartDamage() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MAX_TICK, (Object)120);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.livingTicks < (Integer)this.entityData.get(MAX_TICK) - 8 && this.livingTicks % 5 == 1) {
                for (Vector3f vec : CIRCLE_PARTICLE_MOTION) {
                    AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.78431374f, 0.52156866f, 0.14117648f, 1.0f)).addData((AdvancedParticleData)new MotionData(new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z()), true, false)).addData((AdvancedParticleData)new ScaleData(0.4f)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getX(), this.getY() + 0.2, this.getZ());
                }
            }
        } else {
            if (this.canStartDamage()) {
                this.playSound((SoundEvent)RuneCraftorySounds.ENTITY_AMBROSIA_WAVE.get(), 1.0f, 1.0f);
            }
            if (this.getOwner() != null && !this.getOwner().isAlive()) {
                this.discard();
            }
            this.hitEntityPos.forEach(frozenEntity -> {
                LivingEntity patt0$temp = frozenEntity.entity;
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    player.moveTo(frozenEntity.pos.x(), frozenEntity.pos.y(), frozenEntity.pos.z());
                } else {
                    frozenEntity.entity.setPos(frozenEntity.pos.x(), frozenEntity.pos.y(), frozenEntity.pos.z());
                }
                frozenEntity.entity.hurtMarked = true;
            });
        }
    }

    @Override
    protected boolean canHit(LivingEntity e) {
        return super.canHit(e) && e.distanceToSqr((Entity)this) <= (double)(this.getRadius() * this.getRadius());
    }

    protected AABB damageBoundingBox() {
        float radius = this.getRadius();
        return this.getBoundingBox().inflate((double)radius, 0.75, (double)radius);
    }

    protected boolean damageEntity(LivingEntity e) {
        DynamicDamage.Builder builder = new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(5).element(ItemElement.EARTH).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.DRAIN.asHolder(), 50.0);
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)e, builder, CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            e.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10, 6, true, false));
            this.hitEntityPos.add(new FrozenEntity(e, e.position()));
            return true;
        }
        return false;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(MAX_TICK, (Object)compound.getInt("MaxTick"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("MaxTick", ((Integer)this.entityData.get(MAX_TICK)).intValue());
    }

    record FrozenEntity(LivingEntity entity, Vec3 pos) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof FrozenEntity) {
                FrozenEntity frozenEntity = (FrozenEntity)obj;
                return this.entity == frozenEntity.entity;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.entity.getUUID().hashCode();
        }
    }
}

