/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class BigPlateEntity
extends BaseProjectile {
    private boolean hitSomething;

    public BigPlateEntity(EntityType<? extends BigPlateEntity> type, Level level) {
        super(type, level);
    }

    public BigPlateEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.BIG_PLATE.get()), level, shooter);
    }

    protected EntityHitResult getEntityHit(Vec3 from, Vec3 to) {
        if (!this.isAlive()) {
            return null;
        }
        return BigPlateEntity.getEntityHitResult(this, to, this::canHit);
    }

    private static EntityHitResult getEntityHitResult(AdvancedProjectile projectile, Vec3 to, Predicate<Entity> pred) {
        double dY = to.y() - projectile.getY();
        AABB bb = projectile.getBoundingBox().expandTowards(0.0, dY, 0.0);
        for (Entity e : projectile.level().getEntities((Entity)projectile, bb.inflate(1.0), pred)) {
            if (!e.getBoundingBox().inflate(0.3).intersects(bb)) continue;
            return new EntityHitResult(e);
        }
        return null;
    }

    public boolean isPiercing() {
        return true;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).noKnockback().hurtResistant(5), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null);
        if (!this.hitSomething) {
            this.level().playSound(null, result.getEntity().blockPosition(), (SoundEvent)RuneCraftorySounds.ENTITY_BIG_PLATE_LAND.get(), this.getSoundSource(), 1.0f, 0.5f);
            this.hitSomething = true;
        }
        return att;
    }

    protected void onBlockHit(BlockHitResult blockHitResult) {
        if (!this.hitSomething) {
            this.level().playSound(null, blockHitResult.getBlockPos(), (SoundEvent)RuneCraftorySounds.ENTITY_BIG_PLATE_LAND.get(), this.getSoundSource(), 1.0f, 0.5f);
        }
        this.discard();
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.hitSomething = compound.getBoolean("HitSomething");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HitSomething", this.hitSomething);
    }
}

