/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ButterflyEntity
extends BaseProjectile {
    protected static final EntityDataAccessor<Float> LOCKED_YAW = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> LOCKED_PITCH = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Optional<UUID>> HIT = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<Float> HIT_X = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> HIT_Y = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> HIT_Z = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final int DEFAULT_MAX_TICK = 60;
    private LivingEntity stuckEntity;
    private int livingTickMax = 60;

    public ButterflyEntity(EntityType<? extends ButterflyEntity> type, Level level) {
        super(type, level);
        this.damageMultiplier = 0.15f;
    }

    public ButterflyEntity(Level level, LivingEntity thrower) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.BUTTERFLY.get()), level, thrower);
        this.damageMultiplier = 0.15f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOCKED_YAW, (Object)Float.valueOf(0.0f));
        builder.define(LOCKED_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(HIT, Optional.empty());
        builder.define(HIT_X, (Object)Float.valueOf(0.0f));
        builder.define(HIT_Y, (Object)Float.valueOf(0.0f));
        builder.define(HIT_Z, (Object)Float.valueOf(0.0f));
    }

    public int livingTickMax() {
        return this.livingTickMax;
    }

    public void tick() {
        super.tick();
        LivingEntity stuck = this.getHitEntity();
        if (stuck != null) {
            if (!stuck.isAlive()) {
                this.stuckEntity = null;
                this.entityData.set(HIT, Optional.empty());
                this.discard();
                return;
            }
            this.setXRot(((Float)this.entityData.get(LOCKED_PITCH)).floatValue());
            this.setYRot(((Float)this.entityData.get(LOCKED_YAW)).floatValue());
            Vec3 pos = stuck.position().add((double)((Float)this.entityData.get(HIT_X)).floatValue(), (double)((Float)this.entityData.get(HIT_Y)).floatValue(), (double)((Float)this.entityData.get(HIT_Z)).floatValue());
            this.setPos(pos);
            if (!this.level().isClientSide && this.livingTicks % 40 == 0 && this.getOwner() != null) {
                Entity entity = this.getOwner();
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    CombatUtils.applyTempAttribute(living, (Holder<Attribute>)RuneCraftoryAttributes.DRAIN.asHolder(), 50.0);
                }
                DynamicDamage.Builder builder = new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(0);
                builder.get((HolderLookup.Provider)this.registryAccess()).hurtEntity((Entity)stuck, (float)(CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier));
                Entity entity2 = this.getOwner();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity2;
                    CombatUtils.removeTempAttribute(living, (Holder<Attribute>)RuneCraftoryAttributes.DRAIN.asHolder());
                }
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(4), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            Entity entity = result.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)entity;
                this.hitEntity(livingTarget);
            } else {
                this.discard();
            }
            return true;
        }
        return false;
    }

    private void hitEntity(LivingEntity target) {
        target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 3));
        this.livingTickMax += 60;
        this.entityData.set(LOCKED_PITCH, (Object)Float.valueOf(this.getXRot()));
        this.entityData.set(LOCKED_YAW, (Object)Float.valueOf(this.getYRot()));
        this.entityData.set(HIT, Optional.of(target.getUUID()));
        Vec3 dir = this.position().add(this.getDeltaMovement().scale(1.5)).subtract(target.position()).scale(0.98);
        this.entityData.set(HIT_X, (Object)Float.valueOf((float)dir.x()));
        this.entityData.set(HIT_Y, (Object)Float.valueOf((float)dir.y()));
        this.entityData.set(HIT_Z, (Object)Float.valueOf((float)dir.z()));
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(LOCKED_PITCH, (Object)Float.valueOf(compound.getFloat("LockedPitch")));
        this.entityData.set(LOCKED_YAW, (Object)Float.valueOf(compound.getFloat("LockedYaw")));
        if (compound.hasUUID("HitEntity")) {
            this.entityData.set(HIT, Optional.of(compound.getUUID("HitEntity")));
        }
        this.entityData.set(HIT_X, (Object)Float.valueOf(compound.getFloat("HitX")));
        this.entityData.set(HIT_Y, (Object)Float.valueOf(compound.getFloat("HitY")));
        this.entityData.set(HIT_Z, (Object)Float.valueOf(compound.getFloat("HitZ")));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("LockedPitch", ((Float)this.entityData.get(LOCKED_PITCH)).floatValue());
        compound.putFloat("LockedYaw", ((Float)this.entityData.get(LOCKED_YAW)).floatValue());
        ((Optional)this.entityData.get(HIT)).ifPresent(id -> compound.putUUID("HitEntity", id));
        compound.putFloat("HitX", ((Float)this.entityData.get(HIT_X)).floatValue());
        compound.putFloat("HitY", ((Float)this.entityData.get(HIT_Y)).floatValue());
        compound.putFloat("HitZ", ((Float)this.entityData.get(HIT_Z)).floatValue());
    }

    public LivingEntity getHitEntity() {
        if (this.stuckEntity != null && !this.stuckEntity.isRemoved()) {
            return this.stuckEntity;
        }
        ((Optional)this.entityData.get(HIT)).ifPresent(uuid -> {
            this.stuckEntity = (LivingEntity)EntityUtils.findFromUUID(LivingEntity.class, (Level)this.level(), (UUID)uuid);
            this.onUpdateOwner();
        });
        return this.stuckEntity;
    }
}

