/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class CardsEntity
extends BaseProjectile {
    private static final EntityDataAccessor<Integer> CARD_TYPE = SynchedEntityData.defineId(CardsEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CardsEntity(EntityType<? extends CardsEntity> type, Level level) {
        super(type, level);
        this.damageMultiplier = 0.6f;
    }

    public CardsEntity(Level level, LivingEntity shooter, int type) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.CARDS.get()), level, shooter);
        this.entityData.set(CARD_TYPE, (Object)type);
        this.damageMultiplier = 0.6f;
    }

    public int getCardType() {
        return (Integer)this.entityData.get(CARD_TYPE);
    }

    public int livingTickMax() {
        return 60;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CARD_TYPE, (Object)0);
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).noKnockback().hurtResistant(1).element(ItemElement.LIGHT).projectile(), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null);
        this.discard();
        return att;
    }

    protected void onBlockHit(BlockHitResult blockHitResult) {
        this.discard();
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(CARD_TYPE, (Object)compound.getInt("CardType"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("CardType", this.getCardType());
    }
}

