/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DarknessEntity
extends BaseDamageCloud {
    public DarknessEntity(EntityType<? extends DarknessEntity> type, Level level) {
        super(type, level);
    }

    public DarknessEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.DARKNESS.get()), level, shooter);
        this.setPos(this.getX(), this.getY() + 0.1, this.getZ());
    }

    public int livingTickMax() {
        return 20;
    }

    public boolean canStartDamage() {
        return this.livingTicks == 4;
    }

    public float getRadius() {
        return 2.9f;
    }

    protected boolean damageEntity(LivingEntity livingEntity) {
        boolean flag = CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)livingEntity, new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().element(ItemElement.DARK).hurtResistant(5), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
        if (flag) {
            Vec3 distVec = livingEntity.position().subtract(this.position()).normalize();
            CombatUtils.knockbackEntityIgnoreResistance(livingEntity, 0.8f, distVec.x(), distVec.z());
        }
        return flag;
    }

    protected AABB damageBoundingBox() {
        float radius = this.getRadius();
        return this.getBoundingBox().inflate((double)radius, 0.4, (double)radius);
    }
}

