/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ExplosionSpellEntity
extends BaseProjectile {
    public ExplosionSpellEntity(EntityType<? extends ExplosionSpellEntity> type, Level level) {
        super(type, level);
    }

    public ExplosionSpellEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.EXPLOSION.get()), level, shooter);
        this.tickCount = 5;
    }

    public int livingTickMax() {
        return 15;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            Vec3 dir = this.getDeltaMovement().scale(0.5);
            AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.9647059f, 0.20392157f, 0.20392157f, 0.5f)).addData((AdvancedParticleData)new ScaleData(0.5f)).addData((AdvancedParticleData)new ParticleMetaData(8, false, 0.0f)).add(this.level(), this.getX(), this.getY(), this.getZ());
            AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.9647059f, 0.20392157f, 0.20392157f, 0.5f)).addData((AdvancedParticleData)new ScaleData(0.5f)).addData((AdvancedParticleData)new ParticleMetaData(8, false, 0.0f)).add(this.level(), this.getX() + dir.x(), this.getY() + dir.y(), this.getZ() + dir.z());
        }
    }

    protected float getGravityVelocity() {
        return 0.0025f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        this.doExplosion(result.getEntity().getX(), result.getEntity().getY(), result.getEntity().getZ(), result.getEntity());
        return true;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.doExplosion(result.getLocation().x, result.getLocation().y, result.getLocation().z, null);
    }

    private void doExplosion(double x, double y, double z, Entity hit) {
        this.doExplosion(hit);
        this.level().playSound(null, x, y, z, (Holder)SoundEvents.GENERIC_EXPLODE, this.getSoundSource(), 1.0f, 1.0f);
        this.discard();
        S2CScreenShake.sendAround(this.level(), new Vec3(x, y, z), 16.0, 8, 2.0f);
    }

    protected void doExplosion(Entity hit) {
        if (hit != null) {
            CombatUtils.damageWithFaintAndCrit(this.getOwner(), hit, new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().element(ItemElement.FIRE).hurtResistant(5).knock(DynamicDamage.KnockBackType.BACK, 1.0f), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
        }
        List list = this.level().getEntities((Entity)this, new AABB(-5.0, -5.0, -5.0, 5.0, 5.0, 5.0).move(this.position()));
        for (Entity e : list) {
            double dist = e.distanceToSqr((Entity)this);
            if (dist > 25.0 || e != hit && !this.canHit(e)) continue;
            float dmgPerc = dist > 20.0 ? 0.6f : (dist > 13.0 ? 0.8f : 1.0f);
            CombatUtils.damageWithFaintAndCrit(this.getOwner(), e, new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().element(ItemElement.FIRE).hurtResistant(5).knock(DynamicDamage.KnockBackType.BACK, 1.0f), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier * (double)dmgPerc, null);
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX(), this.getY(), this.getZ(), 2, 1.0, 0.0, 0.0, 1.0);
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damageMultiplier = compound.getFloat("DamageMultiplier");
    }
}

